<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use App\Http\Middleware\CheckRole;
use App\Http\Middleware\CheckComponent;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        // Register your custom middleware aliases here (Laravel 11 style)
        $middleware->alias([
            'role'      => CheckRole::class,
            'component' => CheckComponent::class,
        ]);

        // Optional: you can also add global middleware, redirect guests, etc.
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();