<?php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'layouts.app';
?>



<?php $__env->startSection('title', 'Component 1 – Dashboard'); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <style>
        /* Professional DHIS2/PowerBI Palette */
        :root {
            --dhis2-blue: #2c6693;
            --dhis2-teal: #00796b;
            --dhis2-grey: #f8fafc;
            --border-color: #e2e8f0;
        }

        body { background-color: #f1f5f9; color: #334155; }

        /* Fix for White Space: Remove all negative margins and use standard padding */
        .dashboard-wrapper { padding: 1.5rem; }
        
        .card { 
            border: 1px solid var(--border-color); 
            box-shadow: 0 1px 3px rgba(0,0,0,0.1); 
            border-radius: 8px;
            margin-bottom: 1.5rem; /* Consistent spacing between cards */
        }

        .card-header { 
            background-color: #fff; 
            border-bottom: 1px solid var(--border-color);
            padding: 1rem;
        }

        .card-title { 
            color: var(--dhis2-blue); 
            font-weight: 700; 
            text-transform: uppercase; 
            font-size: 0.85rem; 
            margin: 0;
        }

        /* KPI Cards */
        .stat-card { padding: 1.25rem; border-left: 4px solid var(--dhis2-blue); }
        .stat-value { font-size: 1.5rem; font-weight: 800; display: block; }
        .stat-label { font-size: 0.75rem; color: #64748b; text-transform: uppercase; }

        /* Table Styling */
        .table thead th { 
            background-color: var(--dhis2-grey); 
            text-transform: uppercase; 
            font-size: 0.7rem; 
            letter-spacing: 0.025em;
        }

        /* Map and Chart Sizing - Logic to prevent "White Space" */
        .chart-body { position: relative; width: 100%; height: 280px; }
        #groupMap, #memberMap { width: 100%; height: 350px; border-radius: 0 0 8px 8px; }
        
        .nav-pills .nav-link.active { background-color: var(--dhis2-blue); }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-wrapper">
    <!-- Dashboard Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        Component 1 Dashboard
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="breadcrumb-item active">Component 1</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-lg-6">
                    <div class="d-flex justify-content-lg-end gap-2 dashboard-actions">
                        <a href="<?php echo e(route('component1.groups.index')); ?>" class="btn btn-dhis2-secondary">
                            <i class="fas fa-users me-1"></i> Manage Groups
                        </a>
                        <a href="<?php echo e(route('component1.members.index')); ?>" class="btn btn-dhis2-secondary">
                            <i class="fas fa-user-friends me-1"></i> Members
                        </a>
                        <a href="<?php echo e(route('component1.vsla.report')); ?>" class="btn btn-dhis2-secondary">
                            <i class="fas fa-file-excel"></i> VSLA Monthly Report
                        </a>
                        <!-- <a href="<?php echo e(route('component1.weof.index')); ?>" class="btn btn-dhis2-primary">
                            <i class="fas fa-briefcase me-1"></i> WEOF Beneficiaries
                        </a> -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    

    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="card stat-card">
                <span class="stat-label">Total Groups</span>
                <span class="stat-value text-primary"><?php echo e(number_format($stats['total_groups'])); ?></span>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card" style="border-left-color: var(--dhis2-teal);">
                <span class="stat-label">Total Members</span>
                <span class="stat-value text-success"><?php echo e(number_format($stats['total_members'])); ?></span>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card" style="border-left-color: #f59e0b;">
                <span class="stat-label">Total Supports</span>
                <span class="stat-value text-warning"><?php echo e(number_format($kpiStats['supports'])); ?></span>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stat-card" style="border-left-color: #ef4444;">
                <span class="stat-label">Target Completion</span>
                <span class="stat-value text-danger"><?php echo e(round(($stats['total_groups'] / 800) * 100, 1)); ?>%</span>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            
            <div class="card">
                <div class="card-header"><h6 class="card-title">Engagement Performance (Target vs Achieved)</h6></div>
                <div class="card-body">
                    <table class="table table-hover align-middle">
                        <thead>
                            <tr>
                                <th>Nature</th>
                                <th class="text-center">Target</th>
                                <th class="text-center">Achieved</th>
                                <th class="text-end">Percentage</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = ['matured' => 240, 'progressive' => 160, 'new' => 400]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nature => $target): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php 
                                // Controller uses 'progressive', mapping ensures data shows
                                $achieved = $groupsByNature->where('nature', $nature)->first()->achieved ?? 0;
                            ?>
                            <tr>
                                <td class="text-capitalize fw-bold"><?php echo e($nature); ?></td>
                                <td class="text-center"><?php echo e($target); ?></td>
                                <td class="text-center fw-bold"><?php echo e($achieved); ?></td>
                                <td class="text-end">
                                    <div class="progress" style="height: 8px;">
                                        <div class="progress-bar bg-primary" style="width: <?php echo e(($achieved/$target)*100); ?>%"></div>
                                    </div>
                                    <small><?php echo e(round(($achieved/$target)*100)); ?>%</small>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="card">
                <div class="card-header"><h6 class="card-title">Cumulative Membership Breakdown</h6></div>
                <div class="card-body p-0">
                    <table class="table table-bordered mb-0">
                        <thead>
                            <tr>
                                <th>Category</th>
                                <th class="text-center">Female</th>
                                <th class="text-center">Male</th>
                                <th class="text-center">Adol. Girls</th>
                                <th class="text-center">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = ['matured', 'progressing', 'new']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="text-capitalize bg-light fw-bold"><?php echo e($nature); ?></td>
                                <td class="text-center"><?php echo e(number_format($membershipByNature2[$nature]['female'] ?? 0)); ?></td>
                                <td class="text-center"><?php echo e(number_format($membershipByNature2[$nature]['male'] ?? 0)); ?></td>
                                <td class="text-center"><?php echo e(number_format($membershipByNature2[$nature]['adol_girls'] ?? 0)); ?></td>
                                <td class="text-center fw-bold text-primary"><?php echo e(number_format($membershipByNature2[$nature]['total'] ?? 0)); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="card">
                <div class="card-header"><h6 class="card-title">Trainings & Supports</h6></div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p class="small text-muted text-center fw-bold">Training Completion by Nature</p>
                            <canvas id="trainingChart" height="200"></canvas>
                        </div>
                        <div class="col-md-6">
                            <p class="small text-muted text-center fw-bold">Kits Distributed (Groups)</p>
                            <canvas id="kitsChart" height="200"></canvas>
                        </div>
                        <div class="col-md-6">
                            <p class="small text-muted text-center fw-bold">Kits Distributed (Members)</p>
                            <canvas id="kitsMembersChart" height="200"></canvas>
                        </div>
                        <div class="col-md-6">
                            <p class="small text-muted text-center fw-bold">Group States Map</p>
                            <div id="groupStateMap" style="height: 300px;"></div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <div class="col-lg-4">
            
            <div class="card p-0 overflow-hidden">
                <div class="card-header">
                    <ul class="nav nav-pills card-header-pills" id="mapTab" role="tablist">
                        <li class="nav-item"><button class="nav-link active py-1 px-3 small" data-bs-toggle="tab" data-bs-target="#group-map">Groups</button></li>
                        <li class="nav-item"><button class="nav-link py-1 px-3 small" data-bs-toggle="tab" data-bs-target="#member-map">Members</button></li>
                    </ul>
                </div>
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="group-map"><div id="groupMap"></div></div>
                    <div class="tab-pane fade" id="member-map"><div id="memberMap"></div></div>
                </div>
            </div>

            <div class="card">
                <div class="card-header"><h6 class="card-title">Top 10 Counties by Groups</h6></div>
                <div class="card-body">
                    <canvas id="countyChart" height="300"></canvas>
                </div>
            </div>

            <div class="card">
                <div class="card-header"><h6 class="card-title">Overall Gender Distribution</h6></div>
                <div class="card-body">
                    <canvas id="genderChart" height="200"></canvas>
                </div>
            </div>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // --- Global Config ---
    Chart.defaults.font.size = 11;
    const colors = ['#2c6693', '#00796b', '#f59e0b', '#ef4444', '#8b5cf6'];

    // 1. Training Chart (Left side)
    new Chart(document.getElementById('trainingChart'), {
        type: 'bar',
        data: {
            labels: ['Mature', 'Progressive', 'New'],
            datasets: [{
                label: 'Completed',
                data: [
                    <?php echo e($trainingsCumulative['matured']['total'] ?? 0); ?>,
                    <?php echo e($trainingsCumulative['progressive']['total'] ?? 0); ?>,
                    <?php echo e($trainingsCumulative['new']['total'] ?? 0); ?>

                ],
                backgroundColor: colors[0]
            }]
        },
        options: { plugins: { legend: { display: false } } }
    });

    // 2. Kits Chart (Left side)
    new Chart(document.getElementById('kitsChart'), {
        type: 'bar',
        data: {
            labels: ['Matured', 'Progressive', 'New'],
            datasets: [{
                data: [
                    <?php echo e($kitsGroupsCumulative['matured']['groups'] ?? 0); ?>,
                    <?php echo e($kitsGroupsCumulative['progressive']['groups'] ?? 0); ?>,
                    <?php echo e($kitsGroupsCumulative['new']['groups'] ?? 0); ?>

                ],
                backgroundColor: colors[1]
            }]
        },
        options: { plugins: { legend: { display: false } } }
    });
    // 6. Kits Members
    new Chart(document.getElementById('kitsMembersChart'), {
            type: 'bar',
            data: {
                labels: ['Mature', 'Progressive', 'New'],
                datasets: [{
                    label: 'Members',
                    data: [<?php echo e($kitsMembersCumulative['matured']['total'] ?? 0); ?>, <?php echo e($kitsMembersCumulative['progressive']['total'] ?? 0); ?>, <?php echo e($kitsMembersCumulative['new']['total'] ?? 0); ?>],
                    borderColor: colors[0],
                    backgroundColor: colors[3],
                }]
            },
            options: { plugins: { legend: { display: false } } }
        });

    // 3. County Chart (Right side)
    new Chart(document.getElementById('countyChart'), {
        type: 'bar',
        data: {
            labels: <?php echo json_encode($groupsByCounty->pluck('county')); ?>,
            datasets: [{
                label: 'Groups',
                data: <?php echo json_encode($groupsByCounty->pluck('total')); ?>,
                backgroundColor: colors[0]
            }]
        },
        options: { indexAxis: 'y', plugins: { legend: { display: false } } }
    });

    // 4. Gender Chart (Right side)
    new Chart(document.getElementById('genderChart'), {
        type: 'doughnut',
        data: {
            labels: ['Female', 'Male'],
            datasets: [{
                data: [<?php echo e($genderData['female']); ?>, <?php echo e($genderData['male']); ?>],
                backgroundColor: ['#ec4899', '#3b82f6']
            }]
        },
        options: { cutout: '70%' }
    });

    // --- MAPS ---
    const mapCenter = [7.0, 30.0];
    const groupMap = L.map('groupMap', { scrollWheelZoom: false }).setView(mapCenter, 6);
    L.tileLayer('https://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}{r}.png').addTo(groupMap);
    
    const groupLocations = <?php echo json_encode($groupLocations); ?>;
    groupLocations.forEach(loc => {
        L.circleMarker([loc.lat, loc.lon], { radius: 5, color: colors[0] }).addTo(groupMap).bindPopup(loc.name);
    });

    const memberMap = L.map('memberMap', { scrollWheelZoom: false }).setView(mapCenter, 6);
    L.tileLayer('https://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}{r}.png').addTo(memberMap);
    const memberLocations = <?php echo json_encode($memberLocations); ?>; // Similar aggregation
    memberLocations.forEach(loc => L.circleMarker([loc.lat, loc.lon], { radius: 5, color: colors[1] }).addTo(memberMap).bindPopup(loc.name));

    const groupStateMap = L.map('groupStateMap', { scrollWheelZoom: false }).setView(mapCenter, 6);
    L.tileLayer('https://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}{r}.png').addTo(groupStateMap);
    const groupStateLocations = <?php echo json_encode($groupLocationsByState); ?>;
    groupStateLocations.forEach(loc => L.circleMarker([loc.lat, loc.lon], { radius: 5, color: colors[0] }).addTo(groupStateMap).bindPopup(loc.name));

    // Bootstrap Tab resize fix for Leaflet
    document.querySelectorAll('button[data-bs-toggle="tab"]').forEach(btn => {
        btn.addEventListener('shown.bs.tab', () => {
            groupMap.invalidateSize();
            memberMap.invalidateSize();
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kulzweru/sswseepdatabase.blockchaintech.co.ke/resources/views/component1/dashboard.blade.php ENDPATH**/ ?>