<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - SSWSEEP</title>

    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            background: #f8f9fa;
        }
        .login-card {
            max-width: 420px;
            border: none;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0,0,0,.08);
        }
        .login-header {
            background: #28a745;
            color: white;
            padding: 1rem 0;
            border-top-left-radius: 12px;
            border-top-right-radius: 12px;
            text-align: center;
        }
        .logo-container img {
            height: 70px;
            margin: 0 10px;
        }
        .btn-login {
            background: #28a745;
            border: none;
            font-weight: 600;
            border-radius: 8px;
            padding: .6rem 0;
        }
        .btn-login:hover {
            background: #218838;
        }
        .form-control {
            border-radius: 8px;
            padding: .6rem .75rem;
        }
        .form-check-label {
            font-size: .9rem;
        }
        .alert {
            border-radius: 8px;
        }
    </style>
</head>
<body class="d-flex align-items-center min-vh-100 py-4">

<div class="container">
    <div class="row justify-content-center">
        <div class="col-12 col-md-5">

            <!-- Card -->
            <div class="card login-card">

                <!-- Header with Logos -->
                <div class="login-header">
                    <div class="d-flex justify-content-center align-items-center logo-container">
                        <img src="<?php echo e(asset('images/ministry-logo.png')); ?>" alt="Ministry Logo">
                        <!-- <img src="<?php echo e(asset('images/sswseep-logo-fin.png')); ?>" alt="SSWSEEP Logo"> -->
                    </div>
                    <h5 class="mt-2 mb-0 fw-bold">MGCSW</h5>
                </div>

                <!-- Body -->
                <div class="card-body p-4">

                    <h4 class="text-center mb-4 text-success fw-bold">
                        South Sudan Women’s Social and Economic Empowerment Project (SSWSEEP)
                    </h4>

                    <form method="POST" action="<?php echo e(route('login')); ?>">
                        <?php echo csrf_field(); ?>

                        <!-- Username -->
                        <div class="mb-3">
                            <label for="email" class="form-label fw-medium">Username</label>
                            <input id="email"
                                   type="text"
                                   name="email"
                                   class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   value="<?php echo e(old('email')); ?>"
                                   required autofocus>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Password -->
                        <div class="mb-3">
                            <label for="password" class="form-label fw-medium">Password</label>
                            <input id="password"
                                   type="password"
                                   name="password"
                                   class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   required>
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Remember & Login -->
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="remember">Remember me</label>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-success btn-login w4 w-100">
                            Login
                        </button>
                    </form>

                    <!-- Error Alert -->
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger mt-3 mb-0">
                            <?php echo e($errors->first()); ?>

                        </div>
                    <?php endif; ?>

                </div>
            </div>

        </div>
    </div>
</div>

<!-- Bootstrap JS (optional) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html><?php /**PATH /home/kulzweru/sswseepdatabase.blockchaintech.co.ke/resources/views/auth/login.blade.php ENDPATH**/ ?>