<?php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component2.layouts.app';
?>



<?php $__env->startSection('title', 'Component 2 – WEOF Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Dashboard Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        WEOF Component 2 – Live Dashboard
                    </h1>
                    <p class="text-muted">Real-time analytics for SeedLab & GrowthLab beneficiaries</p>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="breadcrumb-item active">WEOF Component 2 – Live Dashboard</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-lg-6">
                    <div class="d-flex justify-content-lg-end gap-2 dashboard-actions">
                        <a href="<?php echo e(route('component2.seedlab.create')); ?>" class="btn btn-success">
                            <i class="bi bi-person-plus"></i> Add SeedLab Beneficiary
                        </a>
                        <a href="<?php echo e(route('component2.seedlab.index')); ?>" class="btn btn-success">
                            <i class="bi bi-person-plus"></i> Check SeedLab Data
                        </a>
                        <a href="<?php echo e(route('component2.growthlab.create')); ?>" class="btn btn-success">
                            <i class="bi bi-person-plus"></i> Add GrowthLab Beneficiary
                        </a>
                        <a href="<?php echo e(route('component2.growthlab.index')); ?>" class="btn btn-success">
                            <i class="bi bi-person-plus"></i> Check GrowthLab Data
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- QUICK STATS -->
    <div class="row g-4 mb-5">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm text-white bg-primary">
                <div class="card-body text-center">
                    <h3><?php echo e($stats['total_beneficiaries']); ?></h3>
                    <p class="mb-0">Total Beneficiaries</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm text-white bg-success">
                <div class="card-body text-center">
                    <h3><?php echo e($stats['female_count']); ?></h3>
                    <p class="mb-0">Women & Girls</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm text-white bg-info">
                <div class="card-body text-center">
                    <h3>SSP <?php echo e(number_format($stats['total_disbursed'])); ?></h3>
                    <p class="mb-0">Total Grants Disbursed</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm text-white bg-warning">
                <div class="card-body text-center">
                    <h3><?php echo e($stats['utilization_rate']); ?>%</h3>
                    <p class="mb-0">Grant Utilization Rate</p>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <!-- 1. Beneficiaries by Sector -->
        <div class="col-lg-6">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Beneficiaries by Business Sector</h5>
                </div>
                <div class="card-body">
                    <canvas id="sectorChart" height="120"></canvas>
                </div>
            </div>
        </div>

        <!-- 2. Grant Disbursement Progress -->
        <div class="col-lg-6">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Grant Disbursement Status</h5>
                </div>
                <div class="card-body">
                    <canvas id="grantStatusChart" height="120"></canvas>
                </div>
            </div>
        </div>

        <!-- 3. Top 10 Counties by Beneficiaries -->
        <div class="col-lg-8">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Top Counties by Number of Beneficiaries</h5>
                </div>
                <div class="card-body">
                    <canvas id="countyChart" height="80"></canvas>
                </div>
            </div>
        </div>

        <!-- 4. Cohort Progress (SeedLab Only) -->
        <div class="col-lg-4">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">SeedLab Cohort Progress</h5>
                </div>
                <div class="card-body">
                    <canvas id="cohortChart" height="180"></canvas>
                </div>
            </div>
        </div>

        <!-- 5. Module Completion Heatmap (SeedLab) -->
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">SeedLab Module Completion (All Cohorts)</h5>
                </div>
                <div class="card-body">
                    <canvas id="moduleHeatmap" height="60"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Chart.js + Scripts -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/luxon@3.4.0"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-adapter-luxon@1.3.1"></script>

<script>
// All data from Laravel controller
const stats = <?php echo json_encode($stats, 15, 512) ?>;
const chartData = <?php echo json_encode($chartData, 15, 512) ?>;

document.addEventListener('DOMContentLoaded', function () {
    // 1. Sector Distribution
    new Chart(document.getContextById('sectorChart'), {
        type: 'doughnut',
        data: {
            labels: chartData.sectors.labels,
            datasets: [{
                data: chartData.sectors.data,
                backgroundColor: ['#FF6384','#36A2EB','#FFCE56','#4BC0E0E0','#9966FF','#FF9F40','#C9CBCF','#66BB6A']
            }]
        },
        options: { plugins: { legend: { position: 'right' } } }
    });

    // 2. Grant Status
    new Chart(document.getElementById('grantStatusChart'), {
        type: 'pie',
        data: {
            labels: ['Disbursed', 'Approved (Not Paid)', 'No Grant Yet'],
            datasets: [{
                data: [
                    chartData.grants.disbursed,
                    chartData.grants.approved_not_paid,
                    chartData.grants.no_grant
                ],
                backgroundColor: ['#4CAF50', '#FFC107', '#9E9E9E']
            }]
        },
        options: { plugins: { legend: { position: 'bottom' } } }
    });

    // 3. Top Counties
    new Chart(document.getElementById('countyChart'), {
        type: 'bar',
        data: {
            labels: chartData.counties.labels,
            datasets: [{
                label: 'Number of Beneficiaries',
                data: chartData.counties.data,
                backgroundColor: '#36A2EB'
            }]
        },
        options: {
            indexAxis: 'y',
            scales: { x: { beginAtZero: true } }
        }
    });

    // 4. Cohort Progress
    new Chart(document.getElementById('cohortChart'), {
        type: 'bar',
        data: {
            {
            labels: chartData.cohorts.labels,
            datasets: [
                { label: 'Total', data: chartData.cohorts.total, backgroundColor: '#E0E0E0' },
                { label: 'Completed All Modules', data: chartData.cohorts.completed, backgroundColor: '#4CAF50' }
            ]
        },
        options: { scales: { y: { beginAtZero: true } } }
    });

    // 5. Module Heatmap
    new Chart(document.getElementById('moduleHeatmap'), {
        type: 'bar',
        data: {
            labels: ['Module 1','Module 2','Module 3','Module 4','Module 5','Module 6','Module 7','Module 8'],
            datasets: [{
                label: '% Completed',
                data: chartData.modules,
                backgroundColor: '#66BB6A'
            }]
        },
        options: {
            scales: { y: { max: 100, ticks: { callback: v => v + '%' } } },
            plugins: { legend: { display: false } }
        }
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\sswseepcomponents\resources\views/component2/dashboard.blade.php ENDPATH**/ ?>