<?php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component2.layouts.app';
?>



<?php $__env->startSection('title', isset($beneficiary) ? 'Edit SeedLab Beneficiary' : 'Register New SeedLab Beneficiary'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Dashboard Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        SeedLab Beneficiaries Dashboard
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('component2.dashboard')); ?>">Component 2 Dashboard</a></li>
                            <li class="breadcrumb-item active">SeedLab Beneficiaries</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-lg-6">
                    <div class="d-flex justify-content-lg-end gap-2 dashboard-actions">
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row justify-content-center">
        <div class="col-12 col-lg-11">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white">
                    <h4 class="mb-0">
                        <i class="fas fa-seedling"></i>
                        <?php echo e(isset($beneficiary) ? 'Edit SeedLab Beneficiary' : 'Register New SeedLab Beneficiary'); ?>

                    </h4>
                </div>

                <div class="card-body">
                    <form action="<?php echo e(isset($beneficiary) ? route('component2.seedlab.update', $beneficiary) : route('component2.seedlab.store')); ?>"
                          method="POST" id="seedlabForm">
                        <?php echo csrf_field(); ?>
                        <?php if(isset($beneficiary)): ?> <?php echo method_field('PUT'); ?> <?php endif; ?>

                        <!-- BASIC INFO -->
                        <h5 class="mt-4 text-primary">Basic Information</h5>
                        <hr>

                        <div class="row g-3">
                            <div class="col-md-2">
                                <label class="form-label">SN <span class="text-danger">*</span></label>
                                <input type="number" name="sn" class="form-control <?php $__errorArgs = ['sn'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       value="<?php echo e(old('sn', $beneficiary->sn ?? '')); ?>" required>
                                <?php $__errorArgs = ['sn'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Full Name <span class="text-danger">*</span></label>
                                <input type="text" name="full_name" class="form-control <?php $__errorArgs = ['full_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       value="<?php echo e(old('full_name', $beneficiary->full_name ?? '')); ?>" required>
                                <?php $__errorArgs = ['full_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Business Sector <span class="text-danger">*</span></label>
                                <select name="business_sector" class="form-select <?php $__errorArgs = ['business_sector'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                    <option value="">Select sector</option>
                                    <?php $__currentLoopData = ['Agriculture','Education','Healthcare','Real Estate','Services','Supply & Trading','Hospitality','Construction']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($s); ?>" <?php echo e(old('business_sector', $beneficiary->business_sector ?? '') === $s ? 'selected' : ''); ?>>
                                            <?php echo e($s); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="row g-3 mt-3">
                            <div class="col-md-4">
                                <label class="form-label">Cohort / Year <span class="text-danger">*</span></label>
                                <input type="text" name="cohort_year" class="form-control" placeholder="e.g. Cohort 2/25"
                                       value="<?php echo e(old('cohort_year', $beneficiary->cohort_year ?? '')); ?>" required>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Training Centre</label>
                                <select name="training_centre" class="form-select">
                                    <option value="Acacia" <?php echo e(old('training_centre', $beneficiary->training_centre ?? '') === 'Acacia' ? 'selected' : ''); ?>>Acacia</option>
                                    <option value="Women Centre" <?php echo e(old('training_centre', $beneficiary->training_centre ?? '') === 'Women Centre' ? 'selected' : ''); ?>>Women Centre</option>
                                    <option value="Orange Corner" <?php echo e(old('training_centre', $beneficiary->training_centre ?? '') === 'Orange Corner' ? 'selected' : ''); ?>>Orange Corner</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Mobile Number</label>
                                <input type="text" name="mobile_no" class="form-control"
                                       value="<?php echo e(old('mobile_no', $beneficiary->mobile_no ?? '')); ?>">
                            </div>
                        </div>

                        <!-- LOCATION & DEMOGRAPHICS -->
                        <h5 class="mt-5 text-primary">Location & Demographics</h5>
                        <hr>

                        <div class="row g-3">
                            <div class="col-md-4">
                                <label class="form-label">County</label>
                                <input type="text" name="county" class="form-control" value="<?php echo e(old('county', $beneficiary->county ?? '')); ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Payam</label>
                                <input type="text" name="payam" class="form-control" value="<?php echo e(old('payam', $beneficiary->payam ?? '')); ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Boma</label>
                                <input type="text" name="boma" class="form-control" value="<?php echo e(old('boma', $beneficiary->boma ?? '')); ?>">
                            </div>
                        </div>

                        <div class="row g-3 mt-3">
                            <div class="col-md-3">
                                <label class="form-label">Age</label>
                                <input type="number" name="age" class="form-control" min="14" max="100"
                                       value="<?php echo e(old('age', $beneficiary->age ?? '')); ?>">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Gender</label>
                                <select name="gender" class="form-select">
                                    <option value="Female" <?php echo e(old('gender', $beneficiary->gender ?? '') === 'Female' ? 'selected' : ''); ?>>Female</option>
                                    <option value="Male" <?php echo e(old('gender', $beneficiary->gender ?? '') === 'Male' ? 'selected' : ''); ?>>Male</option>
                                    <option value="Adol.Girl" <?php echo e(old('gender', $beneficiary->gender ?? '') === 'Adol.Girl' ? 'selected' : ''); ?>>Adolescent Girl</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Residential Status</label>
                                <select name="residential_status" class="form-select">
                                    <option value="Host" <?php echo e(old('residential_status', $beneficiary->residential_status ?? '') === 'Host' ? 'selected' : ''); ?>>Host</option>
                                    <option value="Returnee" <?php echo e(old('residential_status', $beneficiary->residential_status ?? '') === 'Returnee' ? 'selected' : ''); ?>>Returnee</option>
                                    <option value="IDP" <?php echo e(old('residential_status', $beneficiary->residential_status ?? '') === 'IDP' ? 'selected' : ''); ?>>IDP</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Physical Verification</label>
                                <select name="physical_verification" class="form-select">
                                    <option value="Yes" <?php echo e(old('physical_verification', $beneficiary->physical_verification ?? '') === 'Yes' ? 'selected' : ''); ?>>Yes</option>
                                    <option value="No" <?php echo e(old('physical_verification', $beneficiary->physical_verification ?? '') === 'No' ? 'selected' : ''); ?> selected>No</option>
                                </select>
                            </div>
                        </div>

                        <!-- 8 MODULES -->
                        <h5 class="mt-5 text-primary">Capacity Building Modules (8)</h5>
                        <hr>

                        <div class="row g-3">
                            <?php $__currentLoopData = range(1,8); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <label class="form-label">Module <?php echo e($i); ?></label>
                                    <select name="module_<?php echo e($i); ?>" class="form-select">
                                        <?php $__currentLoopData = ['Not Started','Ongoing','Completed']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($status); ?>"
                                                <?php echo e(old("module_{$i}", $beneficiary["module_{$i}"] ?? 'Not Started') === $status ? 'selected' : ''); ?>>
                                                <?php echo e($status); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <!-- WEOF CONNECT & CERTIFICATE -->
                        <div class="row g-3 mt-4">
                            <div class="col-md-6">
                                <label class="form-label">WEOF Connect Participation (# of times)</label>
                                <input type="number" name="woef_connect_participation" min="0" class="form-control"
                                       value="<?php echo e(old('woef_connect_participation', $beneficiary->woef_connect_participation ?? 0)); ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Received Certificate?</label>
                                <select name="received_certificate" class="form-select">
                                    <option value="Received" <?php echo e(old('received_certificate', $beneficiary->received_certificate ?? '') === 'Received' ? 'selected' : ''); ?>>Received</option>
                                    <option value="Not received" <?php echo e(old('received_certificate', $beneficiary->received_certificate ?? '') !== 'Received' ? 'selected' : ''); ?>>Not received</option>
                                </select>
                            </div>
                        </div>

                        <!-- GRANT SUB-FORM -->
                        <h5 class="mt-5 text-success">Grant & Disbursement Details</h5>
                        <hr class="border-success">

                        <?php if(isset($beneficiary) && $beneficiary->grant): ?>
                            <?php $g = $beneficiary->grant; ?>
                        <?php else: ?>
                            <?php $g = null; ?>
                        <?php endif; ?>

                        <div class="row g-3">
                            <div class="col-md-6">
                                <label>Bank Name</label>
                                <input type="text" name="grant[bank_name]" class="form-control"
                                       value="<?php echo e(old('grant.bank_name', $g->bank_name ?? '')); ?>">
                            </div>
                            <div class="col-md-6">
                                <label>Total Approved (SSP)</label>
                                <input type="number" step="0.01" name="grant[total_approved]" class="form-control"
                                       value="<?php echo e(old('grant.total_approved', $g->total_approved ?? '')); ?>">
                            </div>
                        </div>

                        <div class="row g-3 mt-3">
                            <div class="col-md-6">
                                <label>1st Tranche Amount</label>
                                <input type="number" step="0.01" name="grant[first_tranche_amount]" class="form-control"
                                       value="<?php echo e(old('grant.first_tranche_amount', $g->first_tranche_amount ?? '')); ?>">
                            </div>
                            <div class="col-md-6">
                                <label>1st Tranche Date</label>
                                <input type="date" name="grant[first_tranche_date]" class="form-control"
                                       value="<?php echo e(old('grant.first_tranche_date', $g?->first_tranche_date?->format('Y-m-d') ?? '')); ?>">
                            </div>
                        </div>

                        <div class="row g-3 mt-3">
                            <div class="col-md-6">
                                <label>2nd Tranche Amount</label>
                                <input type="number" step="0.01" name="grant[second_tranche_amount]" class="form-control"
                                       value="<?php echo e(old('grant.second_tranche_amount', $g->second_tranche_amount ?? '')); ?>">
                            </div>
                            <div class="col-md-6">
                                <label>2nd Tranche Date</label>
                                <input type="date" name="grant[second_tranche_date]" class="form-control"
                                       value="<?php echo e(old('grant.second_tranche_date', $g?->second_tranche_date?->format('Y-m-d') ?? '')); ?>">
                            </div>
                        </div>

                        <div class="row g-3 mt-3">
                            <div class="col-md-6">
                                <label>Utilized for Plan?</label>
                                <select name="grant[utilized_for_plan]" class="form-select">
                                    <?php $__currentLoopData = ['Yes','No','Partial']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($opt); ?>" <?php echo e(old('grant.utilized_for_plan', $g->utilized_for_plan ?? 'No') === $opt ? 'selected' : ''); ?>>
                                            <?php echo e($opt); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label>Remarks</label>
                                <textarea name="grant[remarks]" class="form-control" rows="2"><?php echo e(old('grant.remarks', $g->remarks ?? '')); ?></textarea>
                            </div>
                        </div>

                        <!-- SUBMIT -->
                        <div class="mt-5 text-end">
                            <a href="<?php echo e(route('component2.seedlab.index')); ?>" class="btn btn-secondary me-3">Cancel</a>
                            <button type="submit" class="btn btn-success btn-lg">
                                <i class="fas fa-save"></i>
                                <?php echo e(isset($beneficiary) ? 'Update Beneficiary' : 'Save Beneficiary'); ?>

                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kulzweru/sswseepdatabase.blockchaintech.co.ke/resources/views/component2/seedlab/create.blade.php ENDPATH**/ ?>