<?php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'layouts.app';
?>



<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Dashboard Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        VSLA Monthly Summary Report
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="breadcrumb-item active">Auto-generated from live data – matches Excel template</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-lg-6">
                    <div class="d-flex justify-content-lg-end gap-2 dashboard-actions">
                        
                        <a href="<?php echo e(route('component1.vsla-report.export')); ?>" class="btn btn-dhis2-secondary">
                            <i class="fas fa-file-excel"></i> Download Excel Report (Exact Template)
                        </a>
        
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Stats Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <h5>Trained Members</h5>
                    <h3><?php echo e(number_format($trainedMembers)); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h5>Starter Kits Provided</h5>
                    <h3><?php echo e($kitsProvided); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <h5>New Businesses Created</h5>
                    <h3><?php echo e($newBusinesses); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <h5>Productive Assets Value</h5>
                    <h3>$<?php echo e(number_format($productiveAssets, 2)); ?></h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Progress Chart -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5>VSLA Formation Progress vs Targets</h5>
                </div>
                <div class="card-body">
                    <canvas id="progressChart" height="100"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Engagement Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5>VSLA Engagement Data</h5>
                </div>
                <div class="card-body">
                    <table class="table table-bordered table-hover">
                        <thead class="table-success">
                            <tr>
                                <th>Category</th>
                                <th>RF Target</th>
                                <th>Achieved</th>
                                <th>% Progress</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $engagementData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($row['category']); ?></td>
                                <td><?php echo e(number_format($row['target'])); ?></td>
                                <td><?php echo e(number_format($row['achieved'])); ?></td>
                                <td><strong><?php echo e($row['progress']); ?></strong></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const ctx = document.getElementById('progressChart').getContext('2d');
    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: <?php echo json_encode($chartLabels, 15, 512) ?>,
            datasets: [
                {
                    label: 'Target',
                    data: <?php echo json_encode($chartTargets, 15, 512) ?>,
                    backgroundColor: 'rgba(54, 162, 235, 0.6)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Achieved',
                    data: <?php echo json_encode($chartAchieved, 15, 512) ?>,
                    backgroundColor: 'rgba(40, 167, 69, 0.8)',
                    borderColor: 'rgba(40, 167, 69, 1)',
                    borderWidth: 1
                }
            ]
        },
        options: {
            responsive: true,
            scales: { y: { beginAtZero: true } },
            plugins: {
                title: { display: false },
                legend: { position: 'top' }
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kulzweru/sswseepdatabase.blockchaintech.co.ke/resources/views/component1/reports/vsla_summary.blade.php ENDPATH**/ ?>