<?php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component3.layout';
?>



<?php $__env->startSection('title', 'Component 3 - Prevention Sessions Register'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <!-- Main Content -->
        <main class="ms-sm-auto px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-4 border-bottom">
                <h1 class="h2 text-success">Prevention Sessions Register</h1>
                <a href="<?php echo e(route('component3.prevention.create')); ?>" class="btn btn-success btn-lg">
                    <i class="bi bi-plus-circle me-2"></i> Record New Session
                </a>
            </div>

            <!-- Success Message -->
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <!-- Quick Stats Cards -->
            <div class="row mb-4">
                <div class="col-xl-3 col-md-6 mb-3">
                    <div class="card border-left-success shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                        Total Sessions
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        <?php echo e($registers->total()); ?>

                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="bi bi-calendar-event fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-3">
                    <div class="card border-left-primary shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                        Sessions This Month
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        <?php echo e($registers->where('session_date', '>=', now()->startOfMonth())->count()); ?>

                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="bi bi-calendar-check fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Add more quick stats as needed -->
            </div>

            <!-- Data Table -->
            <div class="card shadow mb-4">
                <div class="card-header py-3 bg-success text-white">
                    <h6 class="m-0 font-weight-bold">Registered Prevention Sessions</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover" id="dataTable" width="100%" cellspacing="0">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Session Date</th>
                                    <th>Topic / Theme</th>
                                    <th>Facilitator</th>
                                    <th>Location (County/Payam)</th>
                                    <th>Male Participants</th>
                                    <th>Female Participants</th>
                                    <th>Total Participants</th>
                                    <th>Created By</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $registers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $register): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration + ($registers->currentPage() - 1) * $registers->perPage()); ?></td>
                                        <td><?php echo e($register->session_date->format('d M Y')); ?></td>
                                        <td><?php echo e($register->topic ?? '—'); ?></td>
                                        <td><?php echo e($register->facilitator_name ?? '—'); ?></td>
                                        <td><?php echo e($register->county); ?> / <?php echo e($register->payam); ?></td>
                                        <td><?php echo e($register->male_participants); ?></td>
                                        <td><?php echo e($register->female_participants); ?></td>
                                        <td><?php echo e($register->male_participants + $register->female_participants); ?></td>
                                        <td><?php echo e($register->creator?->name ?? 'System'); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('component3.prevention.show', $register)); ?>"
                                               class="btn btn-sm btn-info text-white" title="View">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="10" class="text-center py-4 text-muted">
                                            No prevention sessions recorded yet.
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        <?php echo e($registers->links()); ?>

                    </div>
                </div>
            </div>

            <!-- Reports Button -->
            <div class="text-end mt-4">
                <a href="<?php echo e(route('component3.prevention.reports')); ?>" class="btn btn-success btn-lg">
                    <i class="bi bi-file-earmark-bar-graph me-2"></i> View Reports & Charts
                </a>
            </div>
        </main>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">
<link href="<?php echo e(asset('vendor/datatables/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="<?php echo e(asset('vendor/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendor/datatables/dataTables.bootstrap5.min.js')); ?>"></script>
<script>
    $(document).ready(function() {
        $('#dataTable').DataTable({
            pageLength: 25,
            responsive: true,
            order: [[1, 'desc']], // newest session first
            columnDefs: [
                { orderable: false, targets: 9 } // disable sorting on Actions column
            ]
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\sswseepcomponents\resources\views/component3/prevention/index.blade.php ENDPATH**/ ?>