<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Component 2 - WEOF Beneficiaries | SSWSEEP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <style>
        body { background: #f8f9fa; }
        .sidebar { background: #006400; min-height: 100vh; }
        .sidebar .nav-link { color: #c8e6c9; border-radius: 8px; margin: 5px 15px; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background: #087f23; color: white; }
        .stat-card { background: #e8f5e9; border-left: 5px solid #006400; }
        .header-logo { height: 60px; }
    </style>
</head>
<body>
    <div class="d-flex">
        <?php echo $__env->make('component2.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <div class="flex-grow-1">
            <header class="bg-white shadow-sm p-3 d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center gap-4">
                    <img src="<?php echo e(asset('images/ministry-logo.png')); ?>" class="header-logo" alt="Ministry">
                    <img src="<?php echo e(asset('images/sswseep-logo.png')); ?>" class="header-logo" alt="SSWSEEP">
                    <h4 class="mb-0 text-success fw-bold">Component 2 – WEOF Beneficiaries</h4>
                </div>
                <div class="text-end">
                    <form method="POST" action="<?php echo e(route('logout')); ?>" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="nav-link text-white bg-transparent border-0">Logout</button>
                    </form>
                </div>
            </header>

            <main class="p-4">
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show">
                        <?php echo e(session('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                <?php echo $__env->yieldContent('content'); ?>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH /home/kulzweru/sswseepdatabase.blockchaintech.co.ke/resources/views/component2/layouts/app.blade.php ENDPATH**/ ?>