<?php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component3.layout';
?>



<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4 py-3">

<!-- Dashboard Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        Component 3 – Quick Stats Dashboard
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="breadcrumb-item active">Component 3</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-lg-6">
                    
                </div>
            </div>
        </div>
    </div>
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="text-success">
                <i class="fas fa-chart-pie"></i> 
            </h2>
            <small class="text-muted">Real-time GBV Helpline & Prevention Overview</small>
        </div>
    </div>

    <!-- <h2 class="text-success fw-bold"><?php echo e(number_format($iri_3_1)); ?> <small class="text-muted">/ 1,200 target</small></h2> -->

    <div class="row g-4 mb-5">
        <div class="col-md-3">
            <div class="card text-white bg-success shadow">
                <div class="card-body">
                    <h5><i class="fas fa-phone-volume"></i> Total Incidents</h5>
                    <h3><?php echo e(number_format($totalIncidents)); ?></h3>
                    <small>+<?php echo e($incidentsLast30Days); ?> last 30 days</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white" style="background:#006400;">
                <div class="card-body">
                    <h5><i class="fas fa-check-circle"></i> Consent Given</h5>
                    <h3><?php echo e(number_format($withConsent)); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-danger shadow">
                <div class="card-body">
                    <h5><i class="fas fa-times-circle"></i> No Consent</h5>
                    <h3><?php echo e(number_format($withoutConsent)); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white" style="background:#28a745;">
                <div class="card-body">
                    <h5><i class="fas fa-users"></i> People Reached (Prevention)</h5>
                    <h3><?php echo e(number_format($totalBeneficiaries)); ?></h3>
                    <small>F: <?php echo e(number_format($femaleBeneficiaries)); ?> | M: <?php echo e(number_format($maleBeneficiaries)); ?></small>
                </div>
            </div>
        </div>
    </div>

    <!--  -->
    <div class="row g-4 mt-5">
        <div class="col-12">
            <h3 class="text-success border-bottom pb-2">
                <i class="fas fa-trophy"></i> Official Performance Indicators (IRI 3.1 – 3.5)
            </h3>
        </div>

        <div class="col-md-6 col-lg-4">
            <div class="card border-success shadow h-100">
                <div class="card-body text-center">
                    <h5 class="text-success">IRI 3.1</h5>
                    <p class="small text-muted">GBV survivors satisfied with hotline services</p>
                    <h2 class="text-success fw-bold"><?php echo e(number_format($iri_3_1)); ?></h2>
                </div>
            </div>
        </div>

        <div class="col-md-6 col-lg-4">
            <div class="card border-primary shadow h-100">
                <div class="card-body text-center">
                    <h5 class="text-primary">IRI 3.2</h5>
                    <p class="small text-muted">People reporting increased awareness of GBV services</p>
                    <h2 class="text-primary fw-bold"><?php echo e(number_format($iri_3_2)); ?></h2>
                </div>
            </div>
        </div>

        <div class="col-md-6 col-lg-4">
            <div class="card border-info shadow h-100">
                <div class="card-body text-center">
                    <h5 class="text-info">IRI 3.3</h5>
                    <p class="small text-muted">Total people benefitting from actions to end GBV</p>
                    <h2 class="text-info fw-bold"><?php echo e(number_format($iri_3_3)); ?></h2>
                </div>
            </div>
        </div>

        <div class="col-md-6 col-lg-4">
            <div class="card border-warning shadow h-100">
                <div class="card-body text-center">
                    <h5 class="text-warning">IRI 3.4</h5>
                    <p class="small text-muted">Female beneficiaries</p>
                    <h2 class="text-warning fw-bold"><?php echo e(number_format($iri_3_4)); ?></h2>
                </div>
            </div>
        </div>

        <div class="col-md-6 col-lg-4">
            <div class="card border-danger shadow h-100">
                <div class="card-body text-center">
                    <h5 class="text-danger">IRI 3.5</h5>
                    <p class="small text-muted">Youth beneficiaries (10–24 years)</p>
                    <h2 class="text-danger fw-bold"><?php echo e(number_format($iri_3_5)); ?></h2>
                </div>
            </div>
        </div>
    </div>

    <!-- End Export Buttons -->
    <!--  -->
    <div class="row mt-5">
        <div class="col-12 text-center">
            <h4 class="text-success mb-4">
                <i class="fas fa-download"></i> Export Full Component 3 Report
            </h4>
            
            <div class="btn-group" role="group">
                <a href="<?php echo e(route('component3.export.pdf')); ?>" 
                class="btn btn-danger btn-lg px-5 shadow">
                    <i class="fas fa-file-pdf"></i> Download PDF Report
                </a>
                
                <a href="<?php echo e(route('component3.export.excel')); ?>" 
                class="btn btn-success btn-lg px-5 shadow">
                    <i class="fas fa-file-excel"></i> Download Excel File
                </a>
            </div>
            
            <p class="text-muted mt-3">
                Includes: Hotline Incidents • Call Logs • Prevention Sessions • Referral Data • IRI 3.1–3.5
            </p>
        </div>
    </div>

    <div class="row">
        <!--  -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="fas fa-pie-chart"></i> GBV Incident Types</h5>
                </div>
                <div class="card-body">
                    <canvas id="gbvTypesChart" height="300"></canvas>
                </div>
            </div>
        </div>

        <!--  -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="fas fa-chalkboard-teacher"></i> Prevention Sessions Delivered</h5>
                </div>
                <div class="card-body">
                    <canvas id="preventionSessionsChart" height="300"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!--  -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    // GBV Types Pie Chart
    new Chart(document.getElementById('gbvTypesChart'), {
        type: 'doughnut',
        data: {
            labels: <?php echo json_encode($gbvTypes->keys()); ?>,
            datasets: [{
                data: <?php echo json_encode($gbvTypes->values()); ?>,
                backgroundColor: [
                    '#ff6384', '#36a2eb', '#ffce56', '#4bc0c0', '#9966ff',
                    '#ff9f40', '#c9cbcf', '#ff5733', '#c70039', '#900c3f'
                ],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { position: 'bottom' },
                title: { display: true, text: 'Distribution of Reported GBV Types' }
            }
        }
    });

    // Prevention Sessions Bar Chart
    new Chart(document.getElementById('preventionSessionsChart'), {
        type: 'bar',
        data: {
            labels: [
                'Prevention Messages',
                'Referral Pathways',
                'Conflict Resolution',
                'Male Engagement',
                'Positive Masculinity'
            ],
            datasets: [{
                label: 'Sessions Delivered',
                data: [
                    <?php echo e($sessionsByType->prevention_messages ?? 0); ?>,
                    <?php echo e($sessionsByType->referral_pathways ?? 0); ?>,
                    <?php echo e($sessionsByType->conflict_resolution ?? 0); ?>,
                    <?php echo e($sessionsByType->male_engagement ?? 0); ?>,
                    <?php echo e($sessionsByType->positive_masculinity ?? 0); ?>

                ],
                backgroundColor: '#006400',
                borderColor: '#004d00',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            scales: { y: { beginAtZero: true } },
            plugins: {
                legend: { display: false },
                title: { display: true, text: 'Community Awareness Sessions' }
            }
        }
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\sswseepcomponents\resources\views/component3/dashboard.blade.php ENDPATH**/ ?>