<?php

namespace App\Exports;

use App\Models\C4Participant;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Illuminate\Support\Facades\Request;

class C4ParticipantsExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize
{
    public function collection()
    {
        $query = C4Participant::query();

        // Apply same filters as in index (we'll pass via session or query string)
        if (Request::has('state') && Request::get('state')) {
            $query->where('state_province', Request::get('state'));
        }
        if (Request::has('gender') && Request::get('gender')) {
            $query->where('gender', Request::get('gender'));
        }
        if (Request::has('module')) {
            $module = Request::get('module');
            if (in_array($module, ['gbv', 'gender_eq', 'project_mgt', 'grm', 'me', 'resource', 'leadership'])) {
                $field = ($module === 'gbv') ? 'trained_gbv_programming' :
                         ($module === 'gender_eq' ? 'trained_gender_equality' :
                         'trained_' . str_replace('_', '', $module));
                $query->where($field, true);
            }
        }

        return $query->get();
    }

    public function headings(): array
    {
        return [
            'S/N', 'Name', 'Organization', 'Designation', 'Gender', 'State/Province',
            'Start Date', 'Completion Date',
            'Project Management', 'GRM', 'M&E', 'GBV Programming', 'Gender Equality',
            'Resource Mobilization', 'Leadership & Management', 'Comment'
        ];
    }

    public function map($participant): array
    {
        return [
            $participant->serial_no ?? '',
            $participant->name,
            $participant->organization ?? '',
            $participant->designation ?? '',
            ucfirst($participant->gender),
            $participant->state_province,
            $participant->start_date?->format('d/m/Y') ?? '',
            $participant->completion_date?->format('d/m/Y') ?? '',
            $participant->trained_project_management ? 'Yes' : 'No',
            $participant->trained_grm ? 'Yes' : 'No',
            $participant->trained_monitoring_evaluation ? 'Yes' : 'No',
            $participant->trained_gbv_programming ? 'Yes' : 'No',
            $participant->trained_gender_equality ? 'Yes' : 'No',
            $participant->trained_resource_mobilization ? 'Yes' : 'No',
            $participant->trained_leadership_management ? 'Yes' : 'No',
            $participant->comment ?? '',
        ];
    }
}