<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;

class AdminController extends Controller
{
    // Super Admin Dashboard (you already have this in routes, but we move it here)
    public function dashboard()
    {
        $stats = [
            'total_groups'      => \App\Models\C1Group::count(),
            'total_users'       => User::count(),
            'active_components' => 4,
        ];

        return view('admin.dashboard', compact('stats'));
    }

    // === USER MANAGEMENT ===

    // List all users
    public function usersIndex()
    {
        $users = User::orderBy('name')
                     ->paginate(15);

        return view('admin.users.index', compact('users'));
    }

    // Show create form
    public function usersCreate()
    {
        return view('admin.users.create');
    }

    // Store new user
    public function usersStore(Request $request)
    {
        $validated = $request->validate([
            'name'       => 'required|string|max:255',
            'email'      => 'required|email|unique:users,email',
            'password'   => 'required|min:8|confirmed',
            'role'       => 'required|in:super_admin,component_1_user,component_2_user,component_3_user,component_4_user',
            'component_id' => 'nullable|integer|between:1,4',
        ]);

        User::create([
            'name'       => $validated['name'],
            'email'      => $validated['email'],
            'password'   => bcrypt($validated['password']),
            'role'       => $validated['role'],
            'component_id' => $validated['component_id'],
        ]);

        return redirect()->route('admin.users.index')
                         ->with('success', 'User created successfully!');
    }
}