<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;

class LoginController extends Controller
{
    
    public function showLoginForm()
    {
        return view('auth.login');
    }

    public function login(Request $request)
    {
        $request->validate([
            'email'    => 'required|email',
            'password' => 'required',
        ]);

        $user = User::where('email', $request->email)->first();

        if (!$user || !$user->is_active) {
            throw ValidationException::withMessages([
                'email' => 'Your account is inactive or does not exist.',
            ]);
        }

        if (Auth::attempt($request->only('email', 'password'), $request->boolean('remember'))) {
            $user->updateLastLogin();

            return $this->redirectBasedOnRole(Auth::user());
        }

        throw ValidationException::withMessages([
            'email' => 'The provided credentials are incorrect.',
        ]);
    }

    public function logout(Request $request)
    {
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect('/');
    }

    protected function redirectBasedOnRole(User $user)
    {
        if ($user->isSuperAdmin()) {
            return redirect()->route('admin.dashboard');
        }

        // Default: first component they have access to
        $firstComponent = $user->components[0] ?? null;
        if ($firstComponent == 2) {
            return redirect()->route("component{$firstComponent}.index"); 
        }elseif ($firstComponent == 3){
            return redirect()->route("component{$firstComponent}.dashboard"); 
        }elseif ($firstComponent == 4){
            return redirect()->route("component{$firstComponent}.index"); 
        }else{
            return redirect()->route("component{$firstComponent}.dashboard");
        }
    }


}