<?php

namespace App\Http\Controllers\Component2;

use App\Http\Controllers\Controller;
use App\Models\C2GrowthlabBusiness;
use App\Models\C2Grant;
use Illuminate\Http\Request;
class C2GrowthlabController extends Controller{

    public function index()
    {
        $businesses = C2GrowthlabBusiness::with('grant')->latest()->paginate(50);

        return view('component2.growthlab.index', [
            'businesses' => $businesses,
            'totalBusinesses' => C2GrowthlabBusiness::count(),
            'femaleOwned' => C2GrowthlabBusiness::whereIn('owner_gender', ['Female', 'Adol.Girl'])->count(),
            'withGrant' => C2GrowthlabBusiness::whereHas('grant')->count(),
            'totalDisbursed' => C2Grant::where('grantable_type', C2GrowthlabBusiness::class)
                                    ->sum('total_received'),
        ]);
    }

    public function create()
    {
        return view('component2.growthlab.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([ /* your rules */ ]);

        $business = C2GrowthlabBusiness::create($request->except('grant'));

        if ($request->has('grant')) {
            $business->grant()->updateOrCreate([], $request->input('grant'));
        }

        return redirect()->route('component2.growthlab.index')->with('success', 'Business saved!');
    }

    public function update(Request $request, C2GrowthlabBusiness $business)
    {
        $business->update($request->except('grant'));

        if ($request->has('grant')) {
            $business->grant()->updateOrCreate([], $request->input('grant'));
        }

        return back()->with('success', 'Business updated!');
    }

}
