<?php

namespace App\Http\Controllers\Component3;

use App\Http\Controllers\Controller;
use App\Models\Component3\HotlineRegister;
use App\Models\Component3\CallLog;
use App\Models\Component3\PreventionRegister;
use App\Models\Component3\ReferralRegister;
use PDF; // laravel-dompdf
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\Component3FullExport;

class ExportController extends Controller
{
    public function pdf()
    {
        $data = [
            'hotline'      => HotlineRegister::all(),
            'call_logs'    => CallLog::all(),
            'prevention'   => PreventionRegister::all(),
            'referrals'    => ReferralRegister::all(),
            'iri_3_1'      => CallLog::where('satisfaction_feedback', true)->count(),
            'iri_3_2'      => PreventionRegister::count(),
            'iri_3_3'      => PreventionRegister::count(),
            'iri_3_4'      => PreventionRegister::where('gender', 'F')->count(),
            'iri_3_5'      => PreventionRegister::whereRaw('age BETWEEN 10 AND 24')
                            ->orWhereIn('category_of_participants', ['Adolescent Girl', 'Adolescent Boy'])
                            ->count(),
            'generated_at' => now()->format('d M Y, H:i'),
        ];

        $pdf = PDF::loadView('component3.exports.pdf', $data)
                  ->setPaper('a4', 'landscape');

        return $pdf->stream('SSWSEEP_Component3_GBV_Report_' . now()->format('Y-m-d') . '.pdf');
    }

    public function excel()
    {
        return Excel::download(new Component3FullExport, 'SSWSEEP_Component3_Full_Data_' . now()->format('Y-m-d') . '.xlsx');
    }
}