<?php

namespace App\Http\Controllers\Component3;

use App\Models\Component3\ReferralRegister;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoreReferralRegisterRequest;
use Illuminate\Http\Request;

class ReferralRegisterController extends Controller
{
    public function index()
    {
        $registers = ReferralRegister::with('creator')
            ->latest('date_of_report')
            ->paginate(20);

        return view('component3.call-log.index', compact('registers'));
    }

    public function create()
    {
        return view('component3.call-log.create');
    }

    public function store(StoreReferralRegisterRequest $request)
    {
        $data = $request->validated();
        $data['created_by'] = auth()->id();

        ReferralRegister::create($data);

        return redirect()->route('component3.call-log.index')
            ->with('success', 'Referral Register incident registered successfully.');
    }

    public function show(ReferralRegister $referralRegister)
    {
        return view('component3.call-log.show', compact('referralRegister'));
    }
}