<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreC3PreventionRegisterRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'gender'                => 'required|in:F,M',
            'category_of_participants' => 'required|string',
            'state'                 => 'required|string|max:191',
            'county'                => 'required|string|max:191',
            'payam'                 => 'required|string|max:191',
            'session_date'          => 'nullable|date',
        ];
    }
}