<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class C2WeofBeneficiary extends Model
{
    protected $table = 'c2_weof_beneficiaries';

    protected $fillable = [
        'group_id', 'woef_id', 'name', 'age', 'marital_status', 'resident_status',
        'county', 'payam', 'education', 'phone_no', 'business_name', 'business_category',
        'business_type', 'establishment_year', 'registration_status', 'target_customers',
        'monthly_revenue', 'financing_sources', 'ever_received_grant', 'ever_received_loan',
        'employees_before_male', 'employees_before_female', 'received_training',
        'training_type', 'training_source', 'participation', 'pre_test_score',
        'post_test_score', 'pitch_outcome', 'onsite_validation', 'accelerator_participation',
        'accelerator_graduation', 'grant_1st_tranche', 'grant_2nd_tranche',
        'business_plan_alignment', 'employees_now_male', 'employees_now_female',
        'profitability', 'sales', 'additional_financing_equity', 'additional_financing_loan',
        'additional_financing_debt', 'additional_financing_grant', 'participation_woef_connect'
    ];

    protected $casts = [
        'financing_sources' => 'array',
        'training_type' => 'array',
        'start_date' => 'date',
        'completion_date' => 'date',
    ];

    public function group()
    {
        return $this->belongsTo(C1Group::class, 'group_id');
    }
}