<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('c3_hotline_registers', function (Blueprint $table) {
            $table->id();
            
            // Administrative Information
            $table->string('incident_id', 50)->unique()->comment('e.g. SS2EE07-003');
            $table->string('survivor_code', 50);
            $table->string('case_manager_code', 50);
            $table->date('date_of_report');
            $table->date('date_of_incident');

            // Survivor Information
            $table->date('date_of_birth')->nullable();
            $table->enum('sex', ['F', 'M']);
            $table->string('ethnicity')->nullable();
            $table->string('country_of_origin')->default('South Sudan');
            $table->enum('civil_marital_status', [
                'Single', 'Married/Cohabitating', 'Widowed', 'Divorced', 'Separated'
            ])->nullable();
            $table->string('displacement_status_at_report')->nullable();
            $table->boolean('person_with_disability')->default(false);
            $table->boolean('unaccompanied_or_separated_child')->default(false);

            // Details of the Incident
            $table->string('stage_of_displacement_at_incident')->nullable();
            $table->string('incident_time_of_day')->nullable(); // Morning, Afternoon, etc.
            $table->string('incident_location')->nullable();
            $table->string('incident_area')->nullable();
            $table->string('incident_sub_area')->nullable();
            $table->string('incident_camp_town')->nullable();
            $table->string('gbv_type'); // Rape, Physical Assault, etc.
            $table->boolean('harmful_traditional_practice')->default(false);
            $table->boolean('money_goods_benefits_exchanged')->default(false);
            $table->string('type_of_abduction')->nullable();
            $table->boolean('previously_reported_this_incident')->default(false);
            $table->boolean('previous_gbv_incidents')->default(false);

            // Alleged Perpetrator Information
            $table->integer('number_of_alleged_perpetrators')->default(1);
            $table->enum('alleged_perpetrator_sex', ['M', 'F'])->nullable();
            $table->string('nationality_of_alleged_perpetrator')->nullable();
            $table->string('alleged_perpetrator_age_group')->nullable(); // Age 18-25, etc.
            $table->string('alleged_perpetrator_relationship_with_survivor')->nullable();
            $table->string('main_occupation_of_alleged_perpetrator')->nullable();

            // Referral Pathway Data
            $table->string('referred_to_you_from')->nullable();
            $table->string('safe_house_shelter')->nullable();
            $table->string('health_medical_services')->nullable();
            $table->string('psychosocial_services')->nullable();
            $table->boolean('wants_legal_action')->default(false);
            $table->string('legal_assistance_service')->nullable();
            $table->string('police_other_security_actor')->nullable();
            $table->string('livelihoods_program')->nullable();
            $table->string('child_protection_service')->nullable();
            $table->string('nfis')->nullable();

            // Consent - MANDATORY
            $table->boolean('consent_given_for_information_sharing')->default(false);

            // Metadata
            $table->foreignId('created_by')->constrained('users')->onDelete('restrict');
            $table->timestamps();

            // Indexes for performance & filtering
            $table->index('incident_id');
            $table->index('survivor_code');
            $table->index('date_of_report');
            $table->index('gbv_type');
            $table->index('consent_given_for_information_sharing');
            $table->index('person_with_disability');
            $table->index('unaccompanied_or_separated_child');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('c3_hotline_registers');
    }
};