<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('c3_prevention_registers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('serial_no')->nullable();

            // Beneficiary Information
            $table->string('name_of_community_member')->nullable();
            $table->enum('gender', ['F', 'M']);
            $table->integer('age')->nullable();
            $table->enum('category_of_participants', [
                'Adult Male', 'Adult Female', 'Adolescent Boy', 
                'Adolescent Girl', 'Community Leader', 'Religious Leader'
            ]);
            $table->boolean('person_with_disability')->default(false);
            $table->boolean('refugee_or_displaced')->default(false);

            // Location - Shorten lengths explicitly
            $table->string('state', 191);
            $table->string('county', 191);
            $table->string('payam', 191);
            $table->string('boma', 191)->nullable();

            // Community Awareness Sessions (multiple can be true)
            $table->boolean('prevention_messages')->default(false);
            $table->boolean('referral_pathways')->default(false);
            $table->boolean('conflict_resolution')->default(false);
            $table->boolean('male_engagement_dialogue')->default(false);
            $table->boolean('positive_masculinity_activity')->default(false);

            // Materials & Media
            $table->boolean('received_iec_materials')->default(false);
            $table->boolean('received_radio_talkshows')->default(false);

            // Other Activities
            $table->text('other_activities_support')->nullable();

            // Metadata
            $table->foreignId('created_by')->constrained('users')->onDelete('restrict');
            $table->date('session_date')->nullable();
            $table->timestamps();

            // Indexes - Use shorter prefixes to fit within 1000 bytes (80*4*3=960)
            $table->index([DB::raw('state(80)'), DB::raw('county(80)'), DB::raw('payam(80)')], 'c3_prevention_registers_location_index');
            $table->index('category_of_participants');
            $table->index('gender');
            $table->index('session_date');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('c3_prevention_registers');
    }
};