<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('c2_growthlab_businesses', function (Blueprint $table) {
            $table->id();

            // Optional link to a VSLA group (Component 1)
            $table->foreignId('group_id')->nullable()->constrained('c1_groups')->onDelete('set null');

            // Serial Number (unique across GrowthLab)
            $table->integer('sn')->unique();

            // Business Information
            $table->string('business_name', 191);
            $table->string('contact_person_name', 191)->nullable();
            $table->string('contact_person_role', 100)->nullable();

            $table->enum('business_sector', [
                'Agriculture', 'Education', 'Healthcare', 'Real Estate',
                'Services', 'Supply & Trading', 'Hospitality', 'Construction'
            ]);
            $table->string('business_type', 191)->nullable();

            $table->enum('residential_status', ['Host', 'Returnee', 'IDP']);
            $table->year('business_formation_year')->nullable();
            $table->string('business_owner_id_no', 50)->nullable();

            // Employees
            $table->integer('no_of_employees')->default(0);
            $table->integer('no_of_female_employees')->default(0);

            // Contact & Location
            $table->string('mobile_no', 20)->nullable();
            $table->string('county', 100)->nullable();
            $table->string('payam', 100)->nullable();
            $table->string('boma', 100)->nullable();

            // Owner Demographics
            $table->integer('owner_age')->nullable();
            $table->enum('owner_gender', ['Female', 'Male', 'Adol.Girl']);
            $table->string('owner_education_level', 191)->nullable();

            // Tailored Capacity Building (GrowthLab has different modules)
            $table->enum('screening_pitch', ['Not Started', 'Ongoing', 'Completed'])->default('Not Started');
            $table->enum('business_diagnostics', ['Not Started', 'Ongoing', 'Completed'])->default('Not Started');

            $table->enum('module_1', ['Not Started', 'Ongoing', 'Completed'])->default('Not Started');
            $table->enum('module_2', ['Not Started', 'Ongoing', 'Completed'])->default('Not Started');
            $table->enum('module_3', ['Not Started', 'Ongoing', 'Completed'])->default('Not Started');
            $table->enum('module_4', ['Not Started', 'Ongoing', 'Completed'])->default('Not Started');
            $table->enum('module_5', ['Not Started', 'Ongoing', 'Completed'])->default('Not Started');
            $table->enum('module_6', ['Not Started', 'Ongoing', 'Completed'])->default('Not Started');

            // Participation & Verification
            $table->integer('woef_connect_participation')->default(0);
            $table->enum('received_certificate', ['Received', 'Not received'])->default('Not received');
            $table->enum('physical_verification', ['Yes', 'No'])->default('No');

            $table->timestamps();
            $table->softDeletes();

            // Indexes for fast reporting & filtering
            $table->index('group_id');
            $table->index('county');
            $table->index('business_sector');
            $table->index('owner_gender');
            $table->index('physical_verification');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('c2_growthlab_businesses');
    }
};