<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    public function run()
    {
        User::updateOrCreate(
            ['email' => 'admin@gbv.org'], // Prevent duplicates
            [
                'name' => 'GBV Admin',
                'email' => 'admin@sswseep.org',
                'password' => Hash::make('Admin123!'), // Change in production!
                'role' => 'super_admin', // or use a roles table if you have one
                'components' => [1, 2, 3, 4],
                'is_active' => true,
            ]
        );

        $this->command->info('Admin user created: admin@gbv.org / Admin123!');
    }
}