<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class ComponentUsersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = [
            // Component 1 – VSLA / Community Groups
            [
                'name'       => 'Component 1 User',
                'email'      => 'c1@sswseep.org',
                'password'   => Hash::make('Component1@2025'),
                'role'       => 'component_1_user',
                'components' => [1],
            ],
            // Component 2 – WEOF Beneficiaries
            [
                'name'       => 'Component 2 User',
                'email'      => 'c2@sswseep.org',
                'password'   => Hash::make('Component2@2025'),
                'role'       => 'component_2_user',
                'components' => [2],
            ],
            // Component 3 – GBV Case Management
            [
                'name'       => 'Component 3 User',
                'email'      => 'c3@sswseep.org',
                'password'   => Hash::make('Component3@2025'),
                'role'       => 'component_3_user',
                'components' => [3],
            ],
            // Component 4 – Training Tracker
            [
                'name'       => 'Component 4 User',
                'email'      => 'c4@sswseep.org',
                'password'   => Hash::make('Component4@2025'),
                'role'       => 'component_4_user',
                'components' => [4],
            ],
        ];

        foreach ($users as $userData) {
            User::updateOrCreate(
                ['email' => $userData['email']], // Prevent duplicates
                [
                    'name'             => $userData['name'],
                    'email'            => $userData['email'],
                    'password'         => $userData['password'],
                    'role'             => $userData['role'],
                    'components'       => $userData['components'], // JSON array or cast in model
                    'is_active'        => true,
                ]
            );
        }

        $this->command->info('Created 4 component users successfully!');
        $this->command->table(['Role', 'Email', 'Password'], [
            ['Component 1 User', 'c1@sswseep.org', 'Component1@2025'],
            ['Component 2 User', 'c2@sswseep.org', 'Component2@2025'],
            ['Component 3 User', 'c3@sswseep.org', 'Component3@2025'],
            ['Component 4 User', 'c4@sswseep.org', 'Component4@2025'],
        ]);
    }
}