<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User::factory(10)->create();

        // User::factory()->create([
        //     'name' => 'Test User',
        //     'email' => 'test@example.com',
        // ]);
        User::create([
            'name' => 'Super Admin',
            'email' => 'superadmin@sswseep.org',
            'password' => bcrypt('password123'),
            'role' => 'super_admin',
            'components' => [1, 2, 3, 4],
            'is_active' => true,
        ]);

        $this->call([
            AdminUserSeeder::class,
            // C1GroupSeeder::class,
            // ... other seeders
        ]);
    }
}
