@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'layouts.app';
@endphp

@extends($layout)

@section('title', 'Component 1 – Dashboard')

@section('content')
<div class="container-fluid py-4">
    <div class="row">
        <!-- Header -->
        <div class="col-12 mb-4">
            <h2 class="text-success fw-bold">Component 1</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active">Dashboard</li>
                </ol>
            </nav>
        </div>
    </div>

    <!-- Quick Stats -->
    <!-- <div class="row g-4 mb-5">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <h5 class="card-title text-muted">Registered VSLA/Community Groups</h5>
                    <h3 class="text-success fw-bold">{{ $kpiStats['groups'] }}</h3>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <h5 class="card-title text-muted">Registered Members</h5>
                    <h3 class="text-success fw-bold">{{ $kpiStats['members'] }}</h3>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <h5 class="card-title text-muted">WEOF Beneficiaries</h5>
                    <h3 class="text-success fw-bold">{{ $kpiStats['weof'] }}</h3>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <h5 class="card-title text-muted">Total Supports</h5>
                    <h3 class="text-success fw-bold">{{ $kpiStats['supports'] }}</h3>
                </div>
            </div>
        </div>
    </div> -->

    <!-- Action Buttons -->
    <div class="row">
        <div class="col-12 text-end">
            <a href="{{ route('component1.groups.index') }}"
               class="btn btn-outline-success me-2">Manage Groups</a>
            <a href="{{ route('component1.members.index') }}"
               class="btn btn-outline-success me-2">Manage Members</a>
            <a href="{{ route('component1.weof.index') }}"
               class="btn btn-success">Manage WEOF Beneficiaries</a>
        </div>
    </div>

    <div>
        <p>&nbsp;</p>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">VSLA Groups</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($stats['total_groups']) }}</div>
                        </div>
                        <div class="col-auto"><i class="fas fa-users fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Members</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($stats['total_members']) }}</div>
                        </div>
                        <div class="col-auto"><i class="fas fa-user-friends fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">WEOF Beneficiaries</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($stats['total_weof']) }}</div>
                        </div>
                        <div class="col-auto"><i class="fas fa-female fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">GBV Vulnerable</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($gbvVulnerable) }}</div>
                        </div>
                        <div class="col-auto"><i class="fas fa-heart-broken fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Total Supports</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $kpiStats['supports'] }}</div>
                        </div>
                        <div class="col-auto"><i class="fas fa-heart-broken fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row" style="width: 80%; margin: 0 auto;">
        <!-- Groups by County -->
        <div class="col-xl-6 col-lg-12 mb-4">
            <div class="card shadow">
                <div class="card-header bg-success text-white">
                    <h6 class="m-0 font-weight-bold">VSLA Groups by County (Top 10)</h6>
                </div>
                <div class="card-body">
                    <canvas id="groupsByCountyChart"></canvas>
                </div>
            </div>
        </div>

        <!-- Gender Pie -->
        <div class="col-xl-6 col-lg-12 mb-4" style="width: 400px!important;">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h6 class="m-0 font-weight-bold">Member Gender Distribution</h6>
                </div>
                <div class="card-body">
                    <canvas id="genderChart"></canvas>
                </div>
            </div>
        </div>

        <!-- WEOF Funnel -->
        <div class="col-xl-8 col-lg-12 mb-4" style="width: 600px!important;">
            <div class="card shadow">
                <div class="card-header bg-info text-white">
                    <h6 class="m-0 font-weight-bold">WEOF Accelerator Funnel</h6>
                </div>
                <div class="card-body">
                    <canvas id="weofFunnelChart"></canvas>
                </div>
            </div>
        </div>

        <!-- Training Bar -->
        <div class="col-xl-4 col-lg-12 mb-4">
            <div class="card shadow">
                <div class="card-header bg-warning text-dark">
                    <h6 class="m-0 font-weight-bold">Core Training Completion</h6>
                </div>
                <div class="card-body">
                    <canvas id="trainingChart"></canvas>
                </div>
            </div>
        </div>
    </div>
@push('scripts')
    <!-- scripts  -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
    <script>
    console.log('script loaded');
    // Groups by County - Bar Chart

    const groupsByCounty = {!! json_encode($groupsByCounty->pluck('county')) !!};
    const groupsByCountyTotal = {!! json_encode($groupsByCounty->pluck('total')) !!};

    new Chart(document.getElementById('groupsByCountyChart'), {
        type: 'bar',
        data: {
            labels: groupsByCounty,
            datasets: [{
                label: 'Number of Groups',
                data: groupsByCountyTotal,
                backgroundColor: '#1cc88a',
                borderColor: '#17a673',
                borderWidth: 1
            }]
        },
        options: { scales: { y: { beginAtZero: true } }, plugins: { legend: { display: false } } }
    });

    // Gender Pie
    new Chart(document.getElementById('genderChart'), {
        type: 'doughnut',
        data: {
            labels: ['Female Members', 'Male Members'],
            datasets: [{
                data: [{{ $genderData['female'] }}, {{ $genderData['male'] }}],
                backgroundColor: ['#e74a3b', '#4e73df'],
                hoverOffset: 20
            }]
        },
        options: { plugins: { legend: { position: 'bottom' } } }
    });

    // WEOF Funnel
    new Chart(document.getElementById('weofFunnelChart'), {
        type: 'bar',
        data: {
            labels: ['Applied', 'Trained', 'Pitch Passed', 'In Accelerator', 'Graduated'],
            datasets: [{
                label: 'Beneficiaries',
                data: [{{ $weofFunnel['applied'] }}, {{ $weofFunnel['received_training'] }}, {{ $weofFunnel['pitch_passed'] }}, {{ $weofFunnel['accelerator'] }}, {{ $weofFunnel['graduated'] }}],
                backgroundColor: '#36b9cc'
            }]
        },
        options: { indexAxis: 'y', scales: { x: { beginAtZero: true } } }
    });

    // Training Completion
    new Chart(document.getElementById('trainingChart'), {
        type: 'bar',
        data: {
            labels: {!! json_encode(array_keys($trainingCompletion)) !!},
            datasets: [{
                label: 'Members Completed',
                data: {!! json_encode(array_values($trainingCompletion)) !!},
                backgroundColor: '#f6c23e'
            }]
        },
        options: { scales: { y: { beginAtZero: true } } }
    });
    </script>
@endpush
</div>
@endsection