@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component2.layouts.app';
@endphp

@extends($layout)

@section('title', isset($business) ? 'Edit GrowthLab Business' : 'Register New GrowthLab Business')

@section('content')
<div class="container-fluid py-4">
    <!-- Dashboard Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        GrowthLab Businesses Dashboard
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('component2.dashboard') }}">Component 2 Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('component2.growthlab.index') }}">GrowthLab Businesses</a></li>
                            <li class="breadcrumb-item active">GrowthLab Businesses</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-lg-6">
                    <div class="d-flex justify-content-lg-end gap-2 dashboard-actions">
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row justify-content-center">
        <div class="col-12 col-lg-10">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white">
                    <h4 class="mb-0">
                        <i class="fas fa-briefcase"></i>
                        {{ isset($business) ? 'Edit GrowthLab Business' : 'Register New GrowthLab Business' }}
                    </h4>
                </div>

                <div class="card-body">
                    <form action="{{ isset($business) ? route('component2.growthlab.update', $business) : route('component2.growthlab.store') }}"
                          method="POST" id="growthlabForm">
                        @csrf
                        @if(isset($business)) @method('PUT') @endif

                        <!-- ==================== BASIC BUSINESS INFO ==================== -->
                        <h5 class="mt-4 text-primary">Business Information</h5>
                        <hr>

                        <div class="row g-3">
                            <div class="col-md-3">
                                <label class="form-label">Serial Number <span class="text-danger">*</span></label>
                                <input type="number" name="sn" class="form-control @error('sn') is-invalid @enderror"
                                       value="{{ old('sn', $business->sn ?? '') }}" required>
                                @error('sn') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>

                            <div class="col-md-9">
                                <label class="form-label">Business Name <span class="text-danger">*</span></label>
                                <input type="text" name="business_name" class="form-control @error('business_name') is-invalid @enderror"
                                       value="{{ old('business_name', $business->business_name ?? '') }}" required>
                                @error('business_name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                        </div>

                        <div class="row g-3 mt-2">
                            <div class="col-md-6">
                                <label class="form-label">Contact Person</label>
                                <input type="text" name="contact_person_name" class="form-control"
                                       value="{{ old('contact_person_name', $business->contact_person_name ?? '') }}" placeholder="Full name">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Role</label>
                                <input type="text" name="contact_person_role" class="form-control"
                                       value="{{ old('contact_person_role', $business->contact_person_role ?? '') }}" placeholder="e.g. CEO, Manager">
                            </div>
                        </div>

                        <div class="row g-3 mt-2">
                            <div class="col-md-6">
                                <label class="form-label">Business Sector <span class="text-danger">*</span></label>
                                <select name="business_sector" class="form-select @error('business_sector') is-invalid @enderror" required>
                                    <option value="">Select sector</option>
                                    @foreach(['Agriculture','Education','Healthcare','Real Estate','Services','Supply & Trading','Hospitality','Construction'] as $sector)
                                        <option value="{{ $sector }}" {{ old('business_sector', $business->business_sector ?? '') === $sector ? 'selected' : '' }}>
                                            {{ $sector }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('business_sector') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Residential Status</label>
                                <select name="residential_status" class="form-select">
                                    <option value="Host" {{ old('residential_status', $business->residential_status ?? '') === 'Host' ? 'selected' : '' }}>Host</option>
                                    <option value="Returnee" {{ old('residential_status', $business->residential_status ?? '') === 'Returnee' ? 'selected' : '' }}>Returnee</option>
                                    <option value="IDP" {{ old('residential_status', $business->residential_status ?? '') === 'IDP' ? 'selected' : '' }}>IDP</option>
                                </select>
                            </div>
                        </div>

                        <!-- ==================== LOCATION & DEMOGRAPHICS ==================== -->
                        <h5 class="mt-5 text-primary">Location & Owner Details</h5>
                        <hr>

                        <div class="row g-3">
                            <div class="col-md-4">
                                <label class="form-label">County</label>
                                <input type="text" name="county" class="form-control" value="{{ old('county', $business->county ?? '') }}">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Payam</label>
                                <input type="text" name="payam" class="form-control" value="{{ old('payam', $business->payam ?? '') }}">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Boma</label>
                                <input type="text" name="boma" class="form-control" value="{{ old('boma', $business->boma ?? '') }}">
                            </div>
                        </div>

                        <div class="row g-3 mt-3">
                            <div class="col-md-4">
                                <label class="form-label">Owner Age</label>
                                <input type="number" name="owner_age" class="form-control" value="{{ old('owner_age', $business->owner_age ?? '') }}">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Owner Gender</label>
                                <select name="owner_gender" class="form-select">
                                    <option value="Female" {{ old('owner_gender', $business->owner_gender ?? '') === 'Female' ? 'selected' : '' }}>Female</option>
                                    <option value="Male" {{ old('owner_gender', $business->owner_gender ?? '') === 'Male' ? 'selected' : '' }}>Male</option>
                                    <option value="Adol.Girl" {{ old('owner_gender', $business->owner_gender ?? '') === 'Adol.Girl' ? 'selected' : '' }}>Adolescent Girl</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Mobile Number</label>
                                <input type="text" name="mobile_no" class="form-control" value="{{ old('mobile_no', $business->mobile_no ?? '') }}">
                            </div>
                        </div>

                        <!-- ==================== TRAINING MODULES ==================== -->
                        <h5 class="mt-5 text-primary">Capacity Building Progress</h5>
                        <hr>

                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Screening & Pitch</label>
                                <select name="screening_pitch" class="form-select">
                                    @foreach(['Not Started','Ongoing','Completed'] as $status)
                                        <option value="{{ $status }}" {{ old('screening_pitch', $business->screening_pitch ?? 'Not Started') === $status ? 'selected' : '' }}>{{ $status }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Business Diagnostics</label>
                                <select name="business_diagnostics" class="form-select">
                                    @foreach(['Not Started','Ongoing','Completed'] as $status)
                                        <option value="{{ $status }}" {{ old('business_diagnostics', $business->business_diagnostics ?? 'Not Started') === $status ? 'selected' : '' }}>{{ $status }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="row g-3 mt-3">
                            @foreach(range(1,6) as $i)
                                <div class="col-md-4">
                                    <label class="Module {{ $i }} Status</label>
                                    <select name="module_{{ $i }}" class="form-select">
                                        @foreach(['Not Started','Ongoing','Completed'] as $status)
                                            <option value="{{ $status }}" {{ old("module_{$i}", $business["module_{$i}"] ?? 'Not Started') === $status ? 'selected' : '' }}>
                                                {{ $status }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            @endforeach
                        </div>

                        <!-- ==================== GRANT SUB-FORM ==================== -->
                        <h5 class="mt-5 text-success mt-5">Grant & Disbursement Details</h5>
                        <hr class="border-success">

                        @if(isset($business) && $business->grant)
                            @php $g = $business->grant; @endphp
                        @else
                            @php $g = null; @endphp
                        @endif

                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Bank Name</label>
                                <input type="text" name="grant[bank_name]" class="form-control"
                                       value="{{ old('grant.bank_name', $g->bank_name ?? '') }}">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Total Amount Approved (SSP)</label>
                                <input type="number" step="0.01" name="grant[total_approved]" class="form-control"
                                       value="{{ old('grant.total_approved', $g->total_approved ?? '') }}">
                            </div>
                        </div>

                        <div class="row g-3 mt-3">
                            <div class="col-md-6">
                                <label class="form-label">1st Tranche Amount</label>
                                <input type="number" step="0.01" name="grant[first_tranche_amount]" class="form-control"
                                       value="{{ old('grant.first_tranche_amount', $g->first_tranche_amount ?? '') }}">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">1st Tranche Date</label>
                                <input type="date" name="grant[first_tranche_date]" class="form-control"
                                       value="{{ old('grant.first_tranche_date', $g?->first_tranche_date?->format('Y-m-d') ?? '') }}">
                            </div>
                        </div>

                        <div class="row g-3 mt-3">
                            <div class="col-md-6">
                                <label class="form-label">2nd Tranche Amount</label>
                                <input type="number" step="0.01" name="grant[second_tranche_amount]" class="form-control"
                                       value="{{ old('grant.second_tranche_amount', $g->second_tranche_amount ?? '') }}">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">2nd Tranche Date</label>
                                <input type="date" name="grant[second_tranche_date]" class="form-control"
                                       value="{{ old('grant.second_tranche_date', $g?->second_tranche_date?->format('Y-m-d') ?? '') }}">
                            </div>
                        </div>

                        <div class="row g-3 mt-3">
                            <div class="col-md-6">
                                <label class="form-label">Utilized for Projected Plan?</label>
                                <select name="grant[utilized_for_plan]" class="form-select">
                                    @foreach(['Yes','No','Partial'] as $opt)
                                        <option value="{{ $opt }}" {{ old('grant.utilized_for_plan', $g->utilized_for_plan ?? 'No') === $opt ? 'selected' : '' }}>{{ $opt }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Remarks</label>
                                <textarea name="grant[remarks]" class="form-control" rows="2">{{ old('grant.remarks', $g->remarks ?? '') }}</textarea>
                            </div>
                        </div>

                        <div class="mt-5 text-end">
                            <a href="{{ route('component2.growthlab.index') }}" class="btn btn-secondary me-3">Cancel</a>
                            <button type="submit" class="btn btn-success btn-lg">
                                <i class="fas fa-save"></i>
                                {{ isset($business) ? 'Update Business' : 'Save Business' }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection