@extends('component2.layouts.app')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h3>WEOF Beneficiaries Dashboard</h3>
    <a href="{{ route('component2.create') }}" class="btn btn-success btn-lg">
        <i class="bi bi-person-plus"></i> Add New Beneficiary
    </a>
</div>

<!-- Stats Cards -->
<div class="row mb-4 g-3">
    <div class="col-md-3"><div class="stat-card p-3 rounded shadow-sm"><h5>Total Beneficiaries</h5><h3 class="text-success">{{ $stats['total'] }}</h3></div></div>
    <div class="col-md-3"><div class="stat-card p-3 rounded shadow-sm"><h5>In Accelerator</h5><h3 class="text-primary">{{ $stats['accelerator'] }}</h3></div></div>
    <div class="col-md-3"><div class="stat-card p-3 rounded shadow-sm"><h5>Graduated</h5><h3 class="text-info">{{ $stats['graduated'] }}</h3></div></div>
    <div class="col-md-3"><div class="stat-card p-3 rounded shadow-sm"><h5>Received Grant</h5><h3 class="text-warning">{{ $stats['grant_received'] }}</h3></div></div>
</div>

<!-- Table -->
<div class="card shadow">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-success">
                    <tr>
                        <th>WEOF ID</th>
                        <th>Name</th>
                        <th>Business</th>
                        <th>County/Payam</th>
                        <th>Accelerator</th>
                        <th>Grant</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($beneficiaries as $b)
                    <tr>
                        <td><strong>{{ $b->woef_id }}</strong></td>
                        <td>{{ $b->name }}</td>
                        <td>{{ $b->business_name }}</td>
                        <td>{{ $b->county }} / {{ $b->payam }}</td>
                        <td>{!! $b->accelerator_participation ? '<i class="bi bi-check-circle text-success"></i>' : '-' !!}</td>
                        <td>{!! $b->grant_1st_tranche || $b->grant_2nd_tranche ? 'Yes' : 'No' !!}</td>
                        <td>
                            <a href="{{ route('component2.edit', $b) }}" class="btn btn-sm btn-warning"><i class="bi bi-pencil"></i></a>
                            <form action="{{ route('component2.destroy', $b) }}" method="POST" class="d-inline">
                                @csrf @method('DELETE')
                                <button class="btn btn-sm btn-danger" onclick="return confirm('Delete?')"><i class="bi bi-trash"></i></button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        {{ $beneficiaries->links() }}
    </div>
</div>
@endsection