@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component3.layout';
@endphp

@extends($layout)

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-users text-success"></i> Record Prevention & Awareness Session</h2>
    <a href="{{ route('component3.prevention.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back
    </a>
</div>

<div class="card border-success">
    <div class="card-body">
        <form action="{{ route('component3.prevention.store') }}" method="POST">
            @csrf

            <div class="row">
                <div class="col-md-4">
                    <label>Gender <span class="text-danger">*</span></label>
                    <select name="gender" class="form-select" required>
                        <option value="F" {{ old('gender') == 'F' ? 'selected' : '' }}>Female</option>
                        <option value="M" {{ old('gender') == 'M' ? 'selected' : '' }}>Male</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label>Age</label>
                    <input type="number" name="age" class="form-control" value="{{ old('age') }}" min="10" max="100">
                </div>
                <div class="col-md-4">
                    <label>Participant Category <span class="text-danger">*</span></label>
                    <select name="category_of_participants" class="form-select" required>
                        <option>Adult Female</option>
                        <option>Adult Male</option>
                        <option>Adolescent Girl</option>
                        <option>Adolescent Boy</option>
                        <option>Community Leader</option>
                        <option>Religious Leader</option>
                    </select>
                </div>
            </div>

            <div class="row mt-3">
                <div class="col-md-3">
                    <label>State <span class="text-danger">*</span></label>
                    <input type="text" name="state" class="form-control" value="{{ old('state') }}" required>
                </div>
                <div class="col-md-3">
                    <label>County <span class="text-danger">*</span></label>
                    <input type="text" name="county" class="form-control" value="{{ old('county') }}" required>
                </div>
                <div class="col-md-3">
                    <label>Payam <span class="text-danger">*</span></label>
                    <input type="text" name="payam" class="form-control" value="{{ old('payam') }}" required>
                </div>
                <div class="col-md-3">
                    <label>Boma</label>
                    <input type="text" name="boma" class="form-control" value="{{ old('boma') }}">
                </div>
            </div>

            <div class="row mt-4">
                <div class="col-12">
                    <h5 class="text-success">Sessions Delivered (Check all that apply)</h5>
                    <div class="row">
                        @foreach(['prevention_messages', 'referral_pathways', 'conflict_resolution', 'male_engagement_dialogue', 'positive_masculinity_activity'] as $session)
                        <div class="col-md-4">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="{{ $session }}" value="1" id="{{ $session }}">
                                <label class="form-check-label" for="{{ $session }}">
                                    {{ ucwords(str_replace('_', ' ', $session)) }}
                                </label>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>

            <div class="row mt-3">
                <div class="col-md-6">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="received_iec_materials" value="1">
                        <label>Received IEC Materials</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="received_radio_talkshows" value="1">
                        <label>Heard Radio Talkshows / Aired Messages</label>
                    </div>
                </div>
                <div class="col-md-6">
                    <label>Session Date</label>
                    <input type="date" name="session_date" class="form-control" value="{{ old('session_date', today()->format('Y-m-d')) }}">
                </div>
            </div>

            <div class="text-center mt-4">
                <button type="submit" class="btn btn-sswseep text-white btn-lg px-5">
                    <i class="fas fa-save"></i> Save Prevention Record
                </button>
            </div>
        </form>
    </div>
</div>
@endsection