@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component3.layout';
@endphp

@extends($layout)

@section('title', 'Prevention Session Details')

@section('content')
<div class="container-fluid">
    <div class="row">
        <main class="ms-sm-auto px-md-4">
            <div class="d-flex justify-content-between align-items-center pt-3 pb-2 mb-4 border-bottom">
                <h1 class="h2 text-success">Prevention Session Details</h1>
                <div>
                    <a href="{{ route('component3.prevention.index') }}" class="btn btn-outline-secondary ms-2">
                        <i class="bi bi-arrow-left"></i> Back
                    </a>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-10">
                    <div class="card shadow">
                        <div class="card-header bg-success text-white">
                            <h5 class="mb-0">
                                {{ $register->topic ?? 'Prevention Session' }} – {{ $register->session_date->format('d M Y') }}
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-4">
                                <div class="col-md-6">
                                    <strong>Session Date:</strong><br>
                                    <span class="text-muted">{{ $register->session_date->format('l, d F Y') }}</span>
                                </div>
                                <div class="col-md-6">
                                    <strong>Topic / Theme:</strong><br>
                                    <span class="text-primary fw-bold">{{ $register->topic ?? '—' }}</span>
                                </div>

                                <div class="col-md-6">
                                    <strong>Facilitator(s):</strong><br>
                                    {{ $register->facilitator_name ?? 'Not recorded' }}
                                </div>

                                <div class="col-md-6">
                                    <strong>Location:</strong><br>
                                    {{ $register->county }}, {{ $register->payam }}
                                </div>

                                <div class="col-md-6">
                                    <strong>Participants:</strong><br>
                                    <span class="badge bg-info fs-6">Male: {{ $register->male_participants }}</span>
                                    <span class="badge bg-pink fs-6 ms-2">Female: {{ $register->female_participants }}</span>
                                    <span class="badge bg-success fs-6 ms-3">
                                        Total: {{ $register->male_participants + $register->female_participants }}
                                    </span>
                                </div>

                                <div class="col-md-6">
                                    <strong>Recorded By:</strong><br>
                                    {{ $register->creator?->name ?? 'System' }}
                                    <br><small class="text-muted">{{ $register->created_at->format('d M Y H:i') }}</small>
                                </div>

                                @if($register->notes)
                                <div class="col-12 mt-3">
                                    <strong>Notes / Remarks:</strong>
                                    <div class="border rounded p-3 bg-light">
                                        {!! nl2br(e($register->notes)) !!}
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>

                        <div class="card-footer text-end">
                            <small class="text-muted">
                                Last updated: {{ $register->updated_at->diffForHumans() }}
                            </small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Mini Chart (optional future Chart.js) -->
            <div class="row mt-4">
                <div class="col-lg-6">
                    <div class="card shadow">
                        <div class="card-header bg-white">
                            <h6>Gender Distribution</h6>
                        </div>
                        <div class="card-body">
                            <canvas id="genderChart" height="200"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const ctx = document.getElementById('genderChart').getContext('2d');
    new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: ['Male Participants', 'Female Participants'],
            datasets: [{
                data: [{{ $register->male_participants }}, {{ $register->female_participants }}],
                backgroundColor: ['#0d6efd', '#d63384'],
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { position: 'bottom' },
                title: { display: false }
            }
        }
    });
});
</script>
@endpush