@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component4.layouts.app';
@endphp

@extends($layout)

@section('content')
<div class="container-fluid px-4 py-3">
    <!-- Dashboard Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        Registered Training Participants - Component 4
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                            <li class="breadcrumb-item active">Component 4</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-lg-6">
                    <div class="d-flex justify-content-lg-end gap-2 dashboard-actions">
                        <a href="{{ route('component4.create') }}" class="btn btn-success">
                            <i class="bi bi-person-plus"></i> Register New
                        </a>
                        <a href="{{ route('component4.export') }}" class="btn btn-info text-white">
                            <i class="bi bi-file-earmark-excel"></i> Export Excel
                        </a>
                        <button onclick="generatePDF()" class="btn btn-danger">
                            <i class="bi bi-file-earmark-pdf"></i> PDF Report
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <form method="GET" action="{{ route('component4.index') }}" class="row g-3 mb-4">
        <div class="col-md-3">
            <select name="state" class="form-select">
                <option value="">All States</option>
                @foreach(\App\Models\Component4\C4Participant::distinct()->orderBy('state_province')->pluck('state_province') as $state)
                    <option value="{{ $state }}" {{ request('state') == $state ? 'selected' : '' }}>{{ $state }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-2">
            <select name="gender" class="form-select">
                <option value="">All Gender</option>
                <option value="female" {{ request('gender')=='female' ? 'selected':'' }}>Female</option>
                <option value="male" {{ request('gender')=='male' ? 'selected':'' }}>Male</option>
                <option value="other" {{ request('gender')=='other' ? 'selected':'' }}>Other</option>
            </select>
        </div>
        <div class="col-md-3">
            <select name="module" class="form-select">
                <option value="">All Training Modules</option>
                <option value="gbv" {{ request('module')=='gbv' ? 'selected':'' }}>GBV Programming</option>
                <option value="gender_eq" {{ request('module')=='gender_eq' ? 'selected':'' }}>Gender Equality</option>
                <option value="project_mgt" {{ request('module')=='project_mgt' ? 'selected':'' }}>Project Management</option>
            </select>
        </div>
        <div class="col-md-2">
            <button type="submit" class="btn btn-primary w-100">Filter</button>
        </div>
        <div class="col-md-2">
            <a href="{{ route('component4.index') }}" class="btn btn-secondary w-100">Clear</a>
        </div>
    </form>

    <!-- Quick Stats Cards -->
    <div class="row mb-4 g-3">
        <div class="col-md-3">
            <div class="stat-card p-3 rounded shadow-sm">
                <h5>Total Participants</h5>
                <h3 class="text-success">{{ $stats['total_participants'] }}</h3>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card p-3 rounded shadow-sm">
                <h5>Female Participants</h5>
                <h3 class="text-danger">{{ $stats['total_female'] }}</h3>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card p-3 rounded shadow-sm">
                <h5>Trained in GBV Programming</h5>
                <h3 class="text-success">{{ $stats['trained_gbv'] }}</h3>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card p-3 rounded shadow-sm">
                <h5>Completed All Modules</h5>
                <h3 class="text-primary">{{ $stats['completed_all'] }}</h3>
            </div>
        </div>
    </div>

    <!-- Visualizations -->
    <div class="row mb-5">
        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">Training Module Completion</h5>
                </div>
                <div class="card-body">
                    <canvas id="moduleChart" height="300"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">Participants by State</h5>
                </div>
                <div class="card-body">
                    <canvas id="stateChart" height="300"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">Gender Distribution</h5>
                </div>
                <div class="card-body">
                    <canvas id="genderChart" height="300"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">GBV & Gender Equality Training</h5>
                </div>
                <div class="card-body">
                    <canvas id="gbvChart" height="300"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Participants Table -->
    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-success">
                        <tr>
                            <th>S/N</th>
                            <th>Name</th>
                            <th>Organization</th>
                            <th>Gender</th>
                            <th>State</th>
                            <th>GBV</th>
                            <th>Gender Eq.</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($participants as $p)
                        <tr>
                            <td>{{ $p->serial_no ?? $loop->iteration }}</td>
                            <td>{{ $p->name }}</td>
                            <td>{{ $p->organization ?? '-' }}</td>
                            <td>
                                <span class="badge bg-{{ $p->gender == 'female' ? 'danger' : 'primary' }}">
                                    {{ ucfirst($p->gender) }}
                                </span>
                            </td>
                            <td>{{ $p->state_province }}</td>
                            <td>{!! $p->trained_gbv_programming ? '<i class="bi bi-check-circle-fill text-success"></i>' : '<i class="bi bi-x-circle text-muted"></i>' !!}</td>
                            <td>{!! $p->trained_gender_equality ? '<i class="bi bi-check-circle-fill text-success"></i>' : '<i class="bi bi-x-circle text-muted"></i>' !!}</td>
                            <td>
                                <a href="{{ route('c4.edit', $p) }}" class="btn btn-sm btn-warning"><i class="bi bi-pencil"></i></a>
                                <form action="{{ route('c4.destroy', $p) }}" method="POST" class="d-inline">
                                    @csrf @method('DELETE')
                                    <button class="btn btn-sm btn-danger" onclick="return confirm('Delete?')"><i class="bi bi-trash"></i></button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr><td colspan="8" class="text-center text-muted py-4">No participants registered yet.</td></tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            {{ $participants->links() }}
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jspdf@2.5.1/dist/jspdf.umd.min.js"></script>
<script>
// Data from Laravel (passed via controller)
const chartData = @json($stats);
const stateData = @json(\App\Models\Component4\C4Participant::selectRaw('state_province, count(*) as total')
    ->groupBy('state_province')->pluck('total', 'state_province'));

new Chart(document.getElementById('moduleChart'), {
    type: 'bar',
    data: {
        labels: ['Project Mgt', 'GRM', 'M&E', 'GBV Prog', 'Gender Eq', 'Resource Mob', 'Leadership'],
        datasets: [{
            label: 'Trained',
            data: [
                {{ \App\Models\Component4\C4Participant::where('trained_project_management', true)->count() }},
                {{ \App\Models\Component4\C4Participant::where('trained_grm', true)->count() }},
                {{ \App\Models\Component4\C4Participant::where('trained_monitoring_evaluation', true)->count() }},
                {{ $stats['trained_gbv'] }},
                {{ $stats['trained_gender_eq'] }},
                {{ \App\Models\Component4\C4Participant::where('trained_resource_mobilization', true)->count() }},
                {{ \App\Models\Component4\C4Participant::where('trained_leadership_management', true)->count() }}
            ],
            backgroundColor: '#006400'
        }]
    },
    options: { responsive: true, plugins: { legend: { display: false } } }
});

new Chart(document.getElementById('stateChart'), {
    type: 'doughnut',
    data: {
        labels: Object.keys(stateData),
        datasets: [{ data: Object.values(stateData), backgroundColor: ['#006400','#087f23','#4caf50','#66bb6a','#81c784','#a5d6a7'] }]
    },
    options: { responsive: true }
});

new Chart(document.getElementById('genderChart'), {
    type: 'pie',
    data: {
        labels: ['Female', 'Male', 'Other'],
        datasets: [{
            data: [{{ $stats['total_female'] }}, {{ $stats['total_male'] }}, {{ \App\Models\Component4\C4Participant::where('gender', 'other')->count() }}],
            backgroundColor: ['#d81b60', '#1976d2', '#9c27b0']
        }]
    }
});

new Chart(document.getElementById('gbvChart'), {
    type: 'bar',
    data: {
        labels: ['GBV Programming', 'Gender Equality'],
        datasets: [{
            label: 'Trained',
            data: [{{ $stats['trained_gbv'] }}, {{ $stats['trained_gender_eq'] }}],
            backgroundColor: ['#d32f2f', '#7b1fa2']
        }]
    },
    options: { indexAxis: 'y', responsive: true }
});

// PDF Export
function generatePDF() {
    const { jsPDF } = window.jspdf;
    const doc = new jsPDF('l', 'mm', 'a4');
    
    doc.setFontSize(18);
    doc.text('Component 4: Training Tracker Report', 15, 20);
    doc.setFontSize(12);
    doc.text(`Generated on: {{ now()->format('d M Y') }}`, 15, 30);
    
    doc.setFontSize(14);
    doc.text('Key Statistics', 15, 45);
    doc.setFontSize(11);
    doc.text(`• Total Participants: {{ $stats['total_participants'] }}`, 20, 55);
    doc.text(`• Female: {{ $stats['total_female'] }} | Male: {{ $stats['total_male'] }}`, 20, 62);
    doc.text(`• Trained in GBV Programming: {{ $stats['trained_gbv'] }}`, 20, 69);
    doc.text(`• Completed All Modules: {{ $stats['completed_all'] }}`, 20, 76);

    // Add table or charts as images (advanced) or keep simple
    doc.save('Component4_Training_Report_{{ now()->format('Y-m-d') }}.pdf');
}
</script>
@endpush