<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Component 4 - Training Tracker | SSWSEEP</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body { background: #f8f9fa; }
        .sidebar { background: #006400; min-height: 100vh; }
        .sidebar .nav-link { color: #c8e6c9; border-radius: 8px; margin: 5px 15px; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background: #087f23; color: white; }
        .stat-card { background: #e8f5e9; border-left: 5px solid #006400; }
        .header-logo { height: 60px; }
    </style>
</head>
<body>
    <div class="d-flex">
        <!-- Sidebar -->
        @include('component4.partials.sidebar')

        <!-- Main Content -->
        <div class="flex-grow-1">
            <!-- Header -->
            <header class="bg-white shadow-sm p-3 d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center gap-4">
                    <img src="{{ asset('images/ministry-logo.png') }}" class="header-logo" alt="Ministry">
                    <h4 class="mb-0 text-success fw-bold">Component 4 - Capacity Building & Training</h4>
                </div>
                <div class="text-end">
                    <span class="text-muted">Welcome,</span><br>
                    <form method="POST" action="{{ route('logout') }}" class="d-inline">
                        @csrf
                        <button type="submit" class="nav-link text-white bg-transparent border-0">Logout</button>
                    </form>
                </div>
            </header>

            <!-- Page Content -->
            <main class="p-4">
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @yield('content')
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    @stack('scripts')
</body>
</html>