<?php

use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Component1\C1DashboardController;
use App\Http\Controllers\Component1\C1GroupController;
use Illuminate\Support\Facades\Route;
use App\Http\Middleware\CheckRole;

// Public
Route::get('/', function () {
    return view('welcome');
});

// Auth Routes
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login']);
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

// Protected Routes (will add middleware later)
// In routes/web.php

Route::middleware(['auth'])->group(function () {

    // Super Admin
    Route::get('/admin/dashboard', function () {
        $stats = [
            'total_groups'        => \App\Models\C1Group::count(),
            'total_weof'          => \App\Models\C1WeofBeneficiary::count(),
            'total_users'         => \App\Models\User::count(),
            'active_components'   => 1, // Only Component 1 is active now
        ];

        return view('admin.dashboard', compact('stats'));
    })->name('admin.dashboard')->middleware('role:super_admin');

    // Component 1
    Route::prefix('component1')
     ->name('component1.')
     ->middleware(['auth', 'component:1'])
     ->group(function () {

    Route::get('/dashboard', C1DashboardController::class)
         ->name('dashboard');
    
    // === Groups CRUD ===
    Route::resource('groups', C1GroupController::class);
    // === Members CRUD ===
    Route::resource('members', C1MemberController::class);
    // === WEOF Beneficiaries CRUD ===
    Route::resource('weof', C1WeofBeneficiaryController::class);
    
});

    // Component 2 (example)
    Route::prefix('component2')->name('component2.')->middleware('component:2')->group(function () {
        Route::get('/dashboard', function () {
            return view('component2.dashboard');
        })->name('dashboard');
    });
});