<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    // public function index()
    // {
    //     return view('home');
    // }

    public function index()
    {
        if (auth()->user()->role === 'super_admin') {
            return redirect()->route('admin.dashboard');
        } elseif (auth()->user()->role === 'component_1_user') {
            return redirect()->route('component1.dashboard');
        }
        
        // Fallback for users with no specific role
        return view('home');
    }
}
