<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class C2GrowthlabBusiness extends Model
{
    use SoftDeletes;

    protected $guarded = ['id'];

    protected $casts = [
        'business_formation_year' => 'integer',
    ];

    // Optional link back to VSLA group
    public function group(): BelongsTo
    {
        return $this->belongsTo(C1Group::class, 'group_id');
    }

    // One-to-one polymorphic with c2_grants
    public function grant(): MorphOne
    {
        return $this->morphOne(C2Grant::class, 'grantable');
    }
}