<?php

namespace App\Models\Component3;

use Illuminate\Database\Eloquent\Model;

class ReferralRegister extends Model
{
    protected $table = 'component3_referral_registers';
    protected $fillable = [
        'serial_no',
        'date',
        'call_in_time',
        'caller_id',
        'gender',
        'age',
        'person_with_disability',
        'residential_status',
        'state',
        'county',
        'payam',
        'boma',
        'denial_resources',
        'rape_case',
        'emotional_abuse',
        'child_marriage',
        'wife_beating',
        'requested_need',
        'actions_taken',
        'referred_to',
        'follow_up_required',
        'follow_up_date',
        'satisfaction_feedback',
        'attendant_name',
        'created_by'
    ];
    protected $casts = [
        'date_of_report' => 'date',
        'date_of_incident' => 'date',
        'consent_info_sharing' => 'boolean',
        'wants_legal_action' => 'boolean',
    ];

    public function creator() { return $this->belongsTo(\App\Models\User::class, 'created_by'); }
}