<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('c1_groups', function (Blueprint $table) {
            $table->id();
            
            // Basic Information - LIMITED LENGTH FOR INDEXES
            $table->string('name', 191)->index();
            $table->enum('nature', ['new', 'progressing', 'matured'])->index();
            $table->string('state', 100);
            $table->string('county', 100);
            $table->string('payam', 100);
            
            // Establishment Information
            $table->string('establishing_org_name')->nullable();
            $table->enum('establishment_type', ['self', 'cso', 'ngo', 'government'])->nullable();
            $table->text('support_received_details')->nullable();
            $table->date('date_formation');
            $table->date('vsla_registration_date')->nullable();
            $table->text('main_activities')->nullable();
            
            // Demographics
            $table->integer('total_members')->default(0);
            $table->integer('num_women')->default(0);
            $table->integer('num_adolescent_girls')->default(0)->comment('14-24 years');
            $table->integer('num_men')->default(0);
            $table->integer('num_adolescent_boys')->default(0)->comment('14-24 years');
            $table->integer('num_women_disability')->default(0)->comment('GBV flag');
            $table->integer('num_widows')->default(0)->comment('GBV flag');
            $table->integer('num_women_heads_hh')->default(0)->comment('GBV flag');
            
            // Leadership
            $table->enum('leadership', ['adolescent_girl', 'woman'])->nullable();
            
            // Performance Metrics
            $table->integer('num_saving_cycles_completed')->default(0);
            $table->decimal('total_credit_given_out', 10, 2)->default(0);
            $table->integer('num_members_investing_existing')->default(0);
            $table->integer('num_members_started_new')->default(0);
            
            // Livelihood Plan
            $table->boolean('has_livelihood_plan')->default(false);
            $table->boolean('livelihood_plan_validated')->default(false);
            
            // In-kind Support
            $table->boolean('received_in_kind_support_plan')->default(false);
            $table->decimal('total_value_in_kind', 10, 2)->default(0);
            $table->integer('num_members_received_in_kind')->default(0);
            $table->integer('num_female_received_in_kind')->default(0);
            $table->integer('num_male_received_in_kind')->default(0);
            
            // Activities
            $table->boolean('initiated_regular_savings')->default(false);
            $table->boolean('created_new_business')->default(false);
            $table->string('type_new_business')->nullable();
            $table->boolean('initiated_credit')->default(false);
            $table->integer('num_benefited_credit')->default(0);
            $table->integer('num_dropouts')->default(0);
            
            // Periodic Updates
            $table->date('month')->nullable()->comment('For periodic updates');
            
            $table->timestamps();
            
            // Indexes for common queries - FIXED
            $table->index('county');
            $table->index('payam');
            $table->index('date_formation');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('c1_groups');
    }
};