<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('c1_weof_beneficiaries', function (Blueprint $table) {
            $table->id();
            
            // Optional link to VSLA groups
            $table->foreignId('group_id')->nullable()->constrained('c1_groups')->onDelete('set null');
            
            // Basic Information - LIMITED LENGTH FOR INDEXES
            $table->string('woef_id', 100)->unique()->comment('WEOF unique identifier');
            $table->string('name', 191);
            $table->integer('age')->nullable();
            $table->enum('marital_status', ['married', 'not_married', 'divorced', 'widowed'])->nullable();
            $table->string('resident_status', 100)->nullable();
            $table->string('county', 100)->nullable();
            $table->string('payam', 100)->nullable();
            $table->string('education')->nullable();
            $table->string('phone_no', 20)->nullable();
            
            // Business Information
            $table->string('business_name', 191);
            $table->string('business_category')->nullable();
            $table->string('business_type')->nullable();
            $table->year('establishment_year')->nullable();
            $table->boolean('registration_status')->default(false);
            $table->text('target_customers')->nullable();
            $table->decimal('monthly_revenue', 10, 2)->nullable();
            $table->json('financing_sources')->nullable()->comment('Array of funding sources');
            $table->boolean('ever_received_grant')->default(false);
            $table->boolean('ever_received_loan')->default(false);
            
            // Employees Before Training
            $table->integer('employees_before_male')->default(0);
            $table->integer('employees_before_female')->default(0);
            
            // Training Information
            $table->boolean('received_training')->default(false);
            $table->json('training_type')->nullable()->comment('Array of training types');
            $table->string('training_source')->nullable();
            
            // Participation & Assessment
            $table->enum('participation', ['successful', '0.5', '0.8', '1_completed'])->nullable();
            $table->decimal('pre_test_score', 3, 2)->nullable()->comment('0.00 to 1.00');
            $table->decimal('post_test_score', 3, 2)->nullable()->comment('0.00 to 1.00');
            $table->string('pitch_outcome')->nullable();
            $table->boolean('onsite_validation')->default(false);
            
            // Accelerator Program
            $table->boolean('accelerator_participation')->default(false);
            $table->boolean('accelerator_graduation')->default(false);
            
            // Grant Tranches
            $table->decimal('grant_1st_tranche', 10, 2)->nullable()->comment('0.6 alignment');
            $table->decimal('grant_2nd_tranche', 10, 2)->nullable()->comment('0.8 alignment');
            $table->decimal('business_plan_alignment', 10, 2)->nullable()->comment('1.0 alignment');
            
            // Current Status
            $table->integer('employees_now_male')->default(0);
            $table->integer('employees_now_female')->default(0);
            $table->decimal('profitability', 10, 2)->nullable();
            $table->decimal('sales', 10, 2)->nullable();
            
            // Additional Financing
            $table->decimal('additional_financing_equity', 10, 2)->nullable();
            $table->decimal('additional_financing_loan', 10, 2)->nullable();
            $table->decimal('additional_financing_debt', 10, 2)->nullable();
            $table->decimal('additional_financing_grant', 10, 2)->nullable();
            
            // WEOF Connect
            $table->boolean('participation_woef_connect')->default(false);
            
            $table->timestamps();
            
            // Indexes - FIXED
            $table->index('group_id');
            $table->index('county');
            $table->index('payam');
            $table->index('accelerator_participation');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('c1_weof_beneficiaries');
    }
};