<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('c4_participants', function (Blueprint $table) {
            $table->id();
            
            // Basic Participant Information
            $table->integer('serial_no')->comment('S/N from tracker');
            $table->string('name');
            $table->string('organization')->nullable();
            $table->string('designation')->nullable();
            $table->enum('gender', ['female', 'male', 'other'])->index();
            $table->string('state_province')->index();
            $table->date('start_date')->nullable();
            $table->date('completion_date')->nullable();
            
            // Training Completions (Booleans for each module)
            // Project Management Category
            $table->boolean('trained_project_management')->default(false);
            $table->boolean('trained_grm')->default(false)->comment('Grievance Redress Mechanism');
            $table->boolean('trained_monitoring_evaluation')->default(false);
            $table->boolean('trained_gbv_programming')->default(false)->index()->comment('GBV flag');
            $table->boolean('trained_gender_equality')->default(false)->index()->comment('GBV flag');
            
            // Institutional Strengthening Category
            $table->boolean('trained_resource_mobilization')->default(false);
            $table->boolean('trained_leadership_management')->default(false);
            // Room for expansion: Add more booleans here if additional modules are identified
            
            // Additional
            $table->text('comment')->nullable()->comment('Comment/Remark');
            
            $table->timestamps();
            
            // Indexes for Reporting
            $table->index('completion_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('c4_participants');
    }
};