<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('c4_indicators', function (Blueprint $table) {
            $table->id();
            
            // KPI Details
            $table->string('kpi_name')->unique()->comment('e.g., Number trained in GBV Programming');
            $table->integer('target')->nullable()->comment('Project target');
            $table->text('definition')->nullable();
            $table->enum('category', ['project_management', 'institutional_strengthening'])->nullable();
            $table->string('training_module')->nullable()->comment('Links to specific module like gbv_programming');
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('c4_indicators');
    }
};