<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Add to c1_groups
        Schema::table('c1_groups', function (Blueprint $table) {
            $table->float('average_participation')->nullable()->after('num_saving_cycles_completed')->comment('Average training participation from template');
            $table->boolean('received_certificate')->default(false)->after('average_participation');
        });

        // Add to c1_members
        Schema::table('c1_members', function (Blueprint $table) {
            $table->enum('category', ['mature', 'progressive', 'new'])->nullable()->after('name')->comment('From template; optional if group-inherited');
            $table->text('existing_income_activities')->nullable()->after('received_specialized_1');
            $table->boolean('received_certificate')->default(false)->after('existing_income_activities');
        });

        // New table for training/re-training activities from Summary Sheet
        Schema::create('c1_trainings', function (Blueprint $table) {
            $table->id();
            $table->string('activity_name')->comment('e.g., VSLA ToT, Male Engagement');
            $table->json('location')->nullable()->comment('State/County etc. as array');
            $table->integer('female_participants')->default(0);
            $table->integer('male_participants')->default(0);
            $table->integer('total_participants')->storedAs('female_participants + male_participants');
            $table->date('period_start')->nullable()->comment('For date ranges like 45870');
            $table->date('period_end')->nullable();
            $table->timestamps();

            // Indexes
            $table->index('activity_name');
            $table->index('period_start');
        });
    }

    public function down(): void
    {
        Schema::table('c1_groups', function (Blueprint $table) {
            $table->dropColumn(['average_participation', 'received_certificate']);
        });

        Schema::table('c1_members', function (Blueprint $table) {
            $table->dropColumn(['category', 'existing_income_activities', 'received_certificate']);
        });

        Schema::dropIfExists('c1_trainings');
    }
};