@extends('layouts.admin')

@section('title', 'Super Admin Dashboard')

@section('content')
<div class="container-fluid py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-lg-12">
            <h1 class="h3 mb-2 text-gray-800">
                <i class="fas fa-crown text-warning"></i> Super Admin Dashboard
            </h1>
            <p class="mb-4 text-muted">
                Welcome, <strong>{{ Auth::user()->name }}</strong> — You have full access to all SSWSEEP components.
            </p>
        </div>
    </div>

    <!-- Quick Stats Cards -->
    <div class="row">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total VSLA Groups (Component 1)
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $stats['total_groups'] ?? 0 }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                WEOF Beneficiaries (Component 1)
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $stats['total_weof'] ?? 0 }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-female fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Active Users
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $stats['total_users'] ?? 0 }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-check fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Components Active
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $stats['active_components'] ?? 0 }} / 4
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-project-diagram fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Component Access Buttons -->
    <div class="row">
        <div class="col-lg-12">
            <h4 class="mb-3"><i class="fas fa-th-large"></i> Access Components</h4>
        </div>

        <!-- Component 1 -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card shadow border-0 h-100">
                <div class="card-body text-center py-5">
                    <i class="fas fa-handshake fa-3x text-success mb-3"></i>
                    <h5 class="card-title">Component 1</h5>
                    <p class="card-text text-muted small">VSLA Groups, Members & WEOF</p>
                    <a href="{{ route('component1.dashboard') }}" class="btn btn-success btn-lg">
                        <i class="fas fa-arrow-right"></i> Enter Component 1
                    </a>
                </div>
            </div>
        </div>

        <!-- Component 2 (Placeholder) -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card shadow border-0 h-100 bg-light">
                <div class="card-body text-center py-5">
                    <i class="fas fa-seedling fa-3x text-secondary mb-3"></i>
                    <h5 class="card-title">Component 2</h5>
                    <p class="card-text text-muted small">Coming Soon</p>
                    <button class="btn btn-secondary btn-lg" disabled>
                        <i class="fas fa-lock"></i> Locked
                    </button>
                </div>
            </div>
        </div>

        <!-- Component 3 & 4 -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card shadow border-0 h-100 bg-light">
                <div class="card-body text-center py-5">
                    <i class="fas fa-heart fa-3x text-danger mb-3"></i>
                    <h5 class="card-title">Component 3</h5>
                    <p class="card-text text-muted small">GBV & Protection</p>
                    <button class="btn btn-secondary btn-lg" disabled>Locked</button>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card shadow border-0 h-100 bg-light">
                <div class="card-body text-center py-5">
                    <i class="fas fa-chart-line fa-3x text-info mb-3"></i>
                    <h5 class="card-title">Component 4</h5>
                    <p class="card-text text-muted small">M&E and Reporting</p>
                    <button class="btn btn-secondary btn-lg" disabled>Locked</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="row mt-5">
        <div class="col-lg-12">
            <h4><i class="fas fa-bolt"></i> Quick Actions</h4>
            <div class="mt-3">
                <a href="{{ route('admin.users.index') ?? '#' }}" class="btn btn-outline-primary mr-2">
                    <i class="fas fa-users-cog"></i> Manage Users
                </a>
                <a href="#" class="btn btn-outline-info mr-2">
                    <i class="fas fa-download"></i> Export Master Data
                </a>
                <a href="#" class="btn btn-outline-warning">
                    <i class="fas fa-shield-alt"></i> System Logs
                </a>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6.5.1/css/all.min.css" rel="stylesheet">
<style>
    .border-left-primary { border-left: 4px solid #4e73df !important; }
    .border-left-success { border-left: 4px solid #1cc88a !important; }
    .border-left-info { border-left: 4px solid #36b9cc !important; }
    .border-left-warning { border-left: 4px solid #f6c23e !important; }
</style>
@endpush