@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'layouts.app';
@endphp

@extends($layout)

@section('title', 'Add New Member')

@section('content')
<div class="container-fluid py-4">
    <h3 class="text-success mb-4">
        Add New Member
        @if($selectedGroup)
            <small class="text-muted">to {{ \App\Models\C1Group::find($selectedGroup)->name }}</small>
        @endif
    </h3>

    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <form action="{{ route('component1.members.store') }}" method="POST">
                @csrf
                <input type="hidden" name="group_id" value="{{ old('group_id', $selectedGroup) }}">

                <!-- === Basic Info === -->
                <div class="row g-3 mb-4">
                    <div class="col-md-6">
                        <label class="form-label">Group <span class="text-danger">*</span></label>
                        <select name="group_id" class="form-select @error('group_id') is-invalid @enderror" required>
                            <option value="">-- Select Group --</option>
                            @foreach($groups as $id => $name)
                                <option value="{{ $id }}" {{ old('group_id', $selectedGroup) == $id ? 'selected' : '' }}>
                                    {{ $name }}
                                </option>
                            @endforeach
                        </select>
                        @error('group_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Serial No. <span class="text-danger">*</span></label>
                        <input type="number" name="serial_no" class="form-control @error('serial_no') is-invalid @enderror"
                               value="{{ old('serial_no') }}" min="1" required>
                        @error('serial_no') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Snapshot Month <span class="text-danger">*</span></label>
                        <input type="month" name="month" class="form-control @error('month') is-invalid @enderror"
                               value="{{ old('month') }}" required>
                        @error('month') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                </div>

                <div class="row g-3 mb-4">
                    <div class="col-md-6">
                        <label class="form-label">Full Name <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control @error('name') is-invalid @enderror"
                               value="{{ old('name') }}" required>
                        @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Gender <span class="text-danger">*</span></label>
                        <select name="gender" class="form-select @error('gender') is-invalid @enderror" required>
                            <option value="">-- Select --</option>
                            <option value="female" {{ old('gender') == 'female' ? 'selected' : '' }}>Female</option>
                            <option value="male" {{ old('gender') == 'male' ? 'selected' : '' }}>Male</option>
                        </select>
                        @error('gender') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Age <span class="text-danger">*</span></label>
                        <input type="number" name="age" class="form-control @error('age') is-invalid @enderror"
                               value="{{ old('age') }}" min="10" max="100" required>
                        @error('age') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                </div>

                <!-- === Roles & GBV Flags === -->
                <div class="row g-3 mb-4">
                    <div class="col-md-3">
                        <div class="form-check mt-4">
                            <input class="form-check-input" type="checkbox" name="exec_committee" value="1"
                                   id="exec_committee" {{ old('exec_committee') ? 'checked' : '' }}>
                            <label class="form-check-label" for="exec_committee">Executive Committee</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-check mt-4">
                            <input class="form-check-input" type="checkbox" name="disability_status" value="1"
                                   id="disability_status" {{ old('disability_status') ? 'checked' : '' }}>
                            <label class="form-check-label" for="disability_status">Has Disability</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-check mt-4">
                            <input class="form-check-input" type="checkbox" name="head_household" value="1"
                                   id="head_household" {{ old('head_household') ? 'checked' : '' }}>
                            <label class="form-check-label" for="head_household">Head of Household</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Marital Status</label>
                        <select name="marital_status" class="form-select">
                            <option value="">-- Select --</option>
                            <option value="married" {{ old('marital_status') == 'married' ? 'selected' : '' }}>Married</option>
                            <option value="not_married" {{ old('marital_status') == 'not_married' ? 'selected' : '' }}>Not Married</option>
                            <option value="divorced" {{ old('marital_status') == 'divorced' ? 'selected' : '' }}>Divorced</option>
                            <option value="widowed" {{ old('marital_status') == 'widowed' ? 'selected' : '' }}>Widowed</option>
                        </select>
                    </div>
                </div>

                <!-- === Household Composition === -->
                <fieldset class="border p-3 rounded mb-4">
                    <legend class="w-auto float-none fs-6 text-success">Household Members</legend>
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label">Total</label>
                            <input type="number" name="num_hh_members_total" class="form-control"
                                   value="{{ old('num_hh_members_total') }}" min="0">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Female Adult</label>
                            <input type="number" name="num_hh_female_adult" class="form-control"
                                   value="{{ old('num_hh_female_adult') }}" min="0">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Female Adol (14–24)</label>
                            <input type="number" name="num_hh_female_adol" class="form-control"
                                   value="{{ old('num_hh_female_adol') }}" min="0">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Male Adult</label>
                            <input type="number" name="num_hh_male_adult" class="form-control"
                                   value="{{ old('num_hh_male_adult') }}" min="0">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Male Adol (14–24)</label>
                            <input type="number" name="num_hh_male_adol" class="form-control"
                                   value="{{ old('num_hh_male_adol') }}" min="0">
                        </div>
                    </div>
                </fieldset>

                <!-- === Core Trainings === -->
                <fieldset class="border p-3 rounded mb-4">
                    <legend class="w-auto float-none fs-6 text-success">Core Trainings Completed</legend>
                    <div class="row g-3">
                        <div class="col-md-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="completed_core_1" value="1"
                                       id="core1" {{ old('completed_core_1') ? 'checked' : '' }}>
                                <label class="form-check-label" for="core1">Functional Literacy</label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="completed_core_2" value="1"
                                       id="core2" {{ old('completed_core_2') ? 'checked' : '' }}>
                                <label class="form-check-label" for="core2">VSLA Operations</label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="completed_core_3" value="1"
                                       id="core3" {{ old('completed_core_3') ? 'checked' : '' }}>
                                <label class="form-check-label" for="core3">Business Dev</label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="completed_core_4" value="1"
                                       id="core4" {{ old('completed_core_4') ? 'checked' : '' }}>
                                <label class="form-check-label" for="core4">Digital Literacy</label>
                            </div>
                        </div>
                    </div>
                </fieldset>

                <!-- === Specialized & Support === -->
                <div class="row g-3 mb-4">
                    <div class="col-md-4">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="received_specialized_1" value="1"
                                   id="specialized" {{ old('received_specialized_1') ? 'checked' : '' }}>
                            <label class="form-check-label" for="specialized">Received Specialized Training</label>
                        </div>
                        <textarea name="specialized_1_details" class="form-control mt-2" rows="2"
                                  placeholder="Details (optional)">{{ old('specialized_1_details') }}</textarea>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">In-Kind Support</label>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="received_in_kind" value="1"
                                   id="in_kind" {{ old('received_in_kind') ? 'checked' : '' }}>
                            <label class="form-check-label" for="in_kind">Received</label>
                        </div>
                        <select name="in_kind_source" class="form-select mt-2">
                            <option value="">-- Source --</option>
                            <option value="sswseep" {{ old('in_kind_source') == 'sswseep' ? 'selected' : '' }}>SSWSEEP</option>
                            <option value="others" {{ old('in_kind_source') == 'others' ? 'selected' : '' }}>Others</option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Productive Equipment</label>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="received_productive_equip" value="1"
                                   id="equip" {{ old('received_productive_equip') ? 'checked' : '' }}>
                            <label class="form-check-label" for="equip">Received</label>
                        </div>
                        <select name="equip_source" class="form-select mt-2">
                            <option value="">-- Source --</option>
                            <option value="sswseep" {{ old('equip_source') == 'sswseep' ? 'selected' : '' }}>SSWSEEP</option>
                            <option value="others" {{ old('equip_source') == 'others' ? 'selected' : '' }}>Others</option>
                        </select>
                    </div>
                </div>

                <!-- === Business & Savings === -->
                <div class="row g-3 mb-4">
                    <div class="col-md-3">
                        <div class="form-check mt-4">
                            <input class="form-check-input" type="checkbox" name="started_new_business" value="1"
                                   id="new_business" {{ old('started_new_business') ? 'checked' : '' }}>
                            <label class="form-check-label" for="new_business">Started New Business</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-check mt-4">
                            <input class="form-check-input" type="checkbox" name="actively_saving_monthly" value="1"
                                   id="saving" {{ old('actively_saving_monthly') ? 'checked' : '' }}>
                            <label class="form-check-label" for="saving">Actively Saving</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Total Savings (SSP)</label>
                        <input type="number" step="0.01" name="total_savings" class="form-control"
                               value="{{ old('total_savings') }}" min="0">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Outstanding Loan (SSP)</label>
                        <input type="number" step="0.01" name="outstanding_loan" class="form-control"
                               value="{{ old('outstanding_loan') }}" min="0">
                    </div>
                </div>

                <!-- === Submit === -->
                <div class="text-end">
                    <a href="{{ route('component1.members.index') }}" class="btn btn-secondary me-2">Cancel</a>
                    <button type="submit" class="btn btn-success px-4">Save Member</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection