@php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component3.layout';
@endphp

@extends($layout)

@section('content')
<h2><i class="fas fa-headset text-success"></i> Record Helpline Call</h2>

<div class="card border-success">
    <div class="card-body">
        <form action="{{ route('component3.call-log.store') }}" method="POST">
            @csrf

            <div class="row g-3">
                <div class="col-md-3"><label>Date <span class="text-danger">*</span></label><input type="date" name="date" class="form-control" required></div>
                <div class="col-md-3"><label>Time</label><input type="time" name="call_in_time" class="form-control"></div>
                <div class="col-md-3"><label>Caller ID</label><input type="text" name="caller_id" class="form-control" required></div>
                <div class="col-md-3"><label>Attendant</label><input type="text" name="attendant_name" class="form-control" value="{{ auth()->user()->name }}" readonly></div>
            </div>

            <div class="row mt-3">
                <div class="col-md-2"><label>Gender</label>
                    <select name="gender" class="form-select"><option>F</option><option>M</option></select>
                </div>
                <div class="col-md-2"><label>Age</label><input type="number" name="age" class="form-control"></div>
                <div class="col-md-4"><label>Residential Status</label>
                    <select name="residential_status" class="form-select">
                        <option>Resident</option><option>Displaced</option><option>Refugee</option>
                    </select>
                </div>
            </div>

            <hr>
            <h5>Incident Type (check all reported)</h5>
            <div class="row">
                @foreach(['denial_resources'=>'Denial of Resources', 'rape_case'=>'Rape', 'emotional_abuse'=>'Emotional Abuse', 'child_marriage'=>'Child Marriage', 'wife_beating'=>'Wife Beating'] as $key => $label)
                <div class="col-md-4">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="{{ $key }}" value="1">
                        <label>{{ $label }}</label>
                    </div>
                </div>
                @endforeach
            </div>

            <div class="mt-3">
                <label>Action Taken / Referred To</label>
                <textarea name="actions_taken" class="form-control" rows="3"></textarea>
            </div>

            <div class="mt-3 text-center">
                <button type="submit" class="btn btn-sswseep text-white btn-lg">Save Call Log</button>
            </div>
        </form>
    </div>
</div>
@endsection