<?php

use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Component1\C1DashboardController;
use App\Http\Controllers\Component1\C1GroupController;
use App\Http\Controllers\Component1\C1MemberController;
use App\Http\Controllers\Component1\C1WeofBeneficiaryController;

use Illuminate\Support\Facades\Route;
use App\Http\Middleware\CheckRole;

// Public
// Route::get('/', function () {
//     return view('welcome');
// });

Route::get('/', function () {
    return redirect()->route('login');
});

// In your routes/web.php, add this route at the root level
Route::get('/home', function () {
    if (auth()->user()->role === 'super_admin') {
        return redirect()->route('admin.dashboard');
    } elseif (auth()->user()->role === 'component_1_user') {
        return redirect()->route('component1.dashboard');
    }
    // Add more role checks as needed
})->name('home');

// Auth Routes
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login']);
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

// Protected Routes (will add middleware later)
// In routes/web.php

Route::middleware(['auth'])->group(function () {

    // === SUPER ADMIN AREA ===
    Route::prefix('admin')->name('admin.')->middleware('role:super_admin')->group(function () {

    // Dashboard (moved from inline closure to controller)
    Route::get('/dashboard', [AdminController::class, 'dashboard'])
         ->name('dashboard');

    // User Management
    Route::get('/users', [AdminController::class, 'usersIndex'])
         ->name('users.index');

    Route::get('/users/create', [AdminController::class, 'usersCreate'])
         ->name('users.create');

    Route::post('/users', [AdminController::class, 'usersStore'])
         ->name('users.store');

    // You can add edit/update/delete later
});

    // Component 1
    Route::prefix('component1')
     ->name('component1.')
     ->middleware(['auth', 'component:1'])
     ->group(function () {

    Route::get('/dashboard', C1DashboardController::class)
         ->name('dashboard');
    
    // === Groups CRUD ===
    Route::resource('groups', C1GroupController::class);
    // === Members CRUD ===
    Route::resource('members', C1MemberController::class);
    // === WEOF Beneficiaries CRUD ===
    Route::resource('weof', C1WeofBeneficiaryController::class);
    
});

    // Component 2 (example)
    Route::prefix('component2')->name('component2.')->middleware('component:2')->group(function () {
        Route::get('/dashboard', function () {
            return view('component2.dashboard');
        })->name('dashboard');
    });
});