<?php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component2.layouts.app';
?>



<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin=""/>
<div class="container-fluid px-4 py-3">
    <!-- Dashboard Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        WEOF Beneficiaries Dashboard
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="breadcrumb-item active">Component 2</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-lg-6">
                    <div class="d-flex justify-content-lg-end gap-2 dashboard-actions">
                        <a href="<?php echo e(route('component2.create')); ?>" class="btn btn-success">
                            <i class="bi bi-person-plus"></i> Add Beneficiary
                        </a>
                        <a href="<?php echo e(route('component2.export')); ?>" class="btn btn-info text-white">
                            <i class="bi bi-file-excel"></i> Export Excel
                        </a>
                        <a href="<?php echo e(route('component2.dashboard')); ?>" class="btn btn-info text-white">
                            <i class="bi bi-speedometer2"></i> WEOF Live Dashboard
                        </a>
                        <button onclick="generatePDF()" class="btn btn-danger">
                            <i class="bi bi-file-pdf"></i> PDF Report
                        </button>
                        <!-- <a href="<?php echo e(route('component1.weof.index')); ?>" class="btn btn-dhis2-primary">
                            <i class="fas fa-briefcase me-1"></i> WEOF Beneficiaries
                        </a> -->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <form method="GET" class="row g-3 mb-4">
        <div class="col-md-3">
            <select name="county" class="form-select">
                <option value="">All Counties</option>
                <?php $__currentLoopData = \App\Models\C2WeofBeneficiary::distinct()->orderBy('county')->pluck('county'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($c); ?>" <?php echo e(request('county')==$c ? 'selected':''); ?>><?php echo e($c); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="col-md-3">
            <select name="accelerator" class="form-select">
                <option value="">Accelerator Status</option>
                <option value="1" <?php echo e(request('accelerator')=='1' ? 'selected':''); ?>>In Accelerator</option>
                <option value="graduated" <?php echo e(request('accelerator')=='graduated' ? 'selected':''); ?>>Graduated</option>
            </select>
        </div>
        <div class="col-md-2">
            <button type="submit" class="btn btn-primary w-100">Filter</button>
        </div>
        <div class="col-md-2">
            <a href="<?php echo e(route('component2.index')); ?>" class="btn btn-secondary w-100">Clear</a>
        </div>
    </form>

    <!-- Stats -->
    <div class="row mb-4 g-3">
        <div class="col-md-3"><div class="stat-card p-3 rounded shadow-sm"><h5>Total</h5><h3 class="text-success"><?php echo e($stats['total']); ?></h3></div></div>
        <div class="col-md-3"><div class="stat-card p-3 rounded shadow-sm"><h5>In Accelerator</h5><h3 class="text-primary"><?php echo e($stats['accelerator']); ?></h3></div></div>
        <div class="col-md-3"><div class="stat-card p-3 rounded shadow-sm"><h5>Graduated</h5><h3 class="text-info"><?php echo e($stats['graduated']); ?></h3></div></div>
        <div class="col-md-3"><div class="stat-card p-3 rounded shadow-sm"><h5>Received Grant</h5><h3 class="text-warning"><?php echo e($stats['grant_received']); ?></h3></div></div>
    </div>

    <!-- Charts -->
    <div class="row mb-5">
        <div class="col-lg-3">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white">Business Registration Status</div>
                <div class="card-body"><canvas id="registrationChart"></canvas></div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white">Accelerator Progress</div>
                <div class="card-body"><canvas id="acceleratorChart"></canvas></div>
            </div>
        </div>
    </div>

    <div class="row mb-5">
        <div class="col-lg-12">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white">Counties and Payams (Click the green circles to view the beneficiaries)</div>
                <div class="card-body">
                    <div class="map-container">
                        <div id="map" style="width: 100%; height: 350px; z-index: 1;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Table -->
    <div class="card shadow">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-success">
                        <tr>
                            <th>WEOF ID</th>
                            <th>Name</th>
                            <th>Business</th>
                            <th>County/Payam</th>
                            <th>Revenue</th>
                            <th>Accelerator</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $beneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><strong><?php echo e($b->woef_id); ?></strong></td>
                            <td><?php echo e($b->name); ?></td>
                            <td><?php echo e(Str::limit($b->business_name, 25)); ?></td>
                            <td><?php echo e($b->county); ?> / <?php echo e($b->payam); ?></td>
                            <td><?php echo e($b->monthly_revenue ? '$'.number_format($b->monthly_revenue) : '-'); ?></td>
                            <td>
                                <?php if($b->accelerator_graduation): ?>
                                    <span class="badge bg-success">Graduated</span>
                                <?php elseif($b->accelerator_participation): ?>
                                    <span class="badge bg-primary">In Program</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">Not Enrolled</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?php echo e(route('component2.edit', $b)); ?>" class="btn btn-sm btn-warning"><i class="bi bi-pencil"></i></a>
                                <form action="<?php echo e(route('component2.destroy', $b)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                    <button class="btn btn-sm btn-danger" onclick="return confirm('Delete?')"><i class="bi bi-trash"></i></button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="7" class="text-center py-4 text-muted">No beneficiaries found.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e($beneficiaries->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jspdf@2.5.1/dist/jspdf.umd.min.js"></script>
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<script>
const stats = <?php echo json_encode($stats, 15, 512) ?>;
const registered = <?php echo e(\App\Models\C2WeofBeneficiary::where('registration_status', true)->count()); ?>;
const notRegistered = <?php echo e(\App\Models\C2WeofBeneficiary::where('registration_status', false)->count()); ?>;

new Chart(document.getElementById('registrationChart'), {
    type: 'doughnut',
    data: {
        labels: ['Registered', 'Not Registered'],
        datasets: [{ data: [registered, notRegistered], backgroundColor: ['#006400', '#dc3545'] }]
    },
    options: { responsive: true }
});

new Chart(document.getElementById('acceleratorChart'), {
    type: 'bar',
    data: {
        labels: ['Applied', 'In Program', 'Graduated'],
        datasets: [{
            label: 'Count',
            data: [
                <?php echo e(\App\Models\C2WeofBeneficiary::whereNotNull('pitch_outcome')->count()); ?>,
                stats.accelerator,
                stats.graduated
            ],
            backgroundColor: '#006400'
        }]
    },
    options: { responsive: true }
});

function generatePDF() {
    const { jsPDF } = window.jspdf;
    const doc = new jsPDF('l', 'mm', 'a4');
    doc.setFontSize(18);
    doc.text('WEOF Beneficiaries Report', 15, 20);
    doc.setFontSize(12);
    doc.text('Generated: <?php echo e(now()->format('d M Y')); ?>', 15, 30);
    doc.setFontSize(11);
    doc.text(`Total: ${stats.total} | Accelerator: ${stats.accelerator} | Graduated: ${stats.graduated}`, 15, 45);
    doc.save('WEOF_Report_<?php echo e(now()->format('Y-m-d')); ?>.pdf');
}
// --- MAP INITIALIZATION ---
document.addEventListener("DOMContentLoaded", function() {
    
    // 1. Initialize Map centered on South Sudan
    var map = L.map('map', { scrollWheelZoom: false }).setView([7.0, 30.0], 6); 

    // 2. Add OpenStreetMap Tile Layer
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '&copy; OpenStreetMap contributors'
    }).addTo(map);

    // 3. Get Data from Controller
    const mapData = <?php echo json_encode($mapData ?? [], 15, 512) ?>;

    console.log(mapData);

    // 4. Loop through data and add markers
    mapData.forEach(item => {
        // Create a circle marker (looks cleaner for data visualization)
        // Radius scales slightly with count to show density
        var radiusSize = Math.min(Math.max(item.count * 1.5, 10), 30); 

        var circle = L.circleMarker([item.lat, item.lng], {
            color: '#006400',       // Dark Green outline (matching your theme)
            fillColor: '#198754',   // Success Green fill
            fillOpacity: 0.7,
            radius: 12              // Fixed radius, or use radiusSize for dynamic
        }).addTo(map);

        // Add Popup
        circle.bindPopup(`
            <div class="text-center">
                <strong>${item.name}</strong><br>
                <span class="badge bg-success">${item.count} Beneficiaries</span>
            </div>
        `);
    });

    // Fix for map not rendering tiles correctly if hidden initially
    setTimeout(function(){ map.invalidateSize()}, 400);
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\sswseepcomponents\resources\views/component2/index.blade.php ENDPATH**/ ?>