<?php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'layouts.app';
?>



<?php $__env->startSection('title', 'Register New Group'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4 py-3">
    <!-- Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        Register New Group
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('component1.dashboard')); ?>">Component 1 Dashboard</a></li>
                            <li class="breadcrumb-item active">Groups</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <h3 class="text-success mb-4 text-center fw-bold">Register New VSLA/Community Group</h3>

            <div class="card border-secondary border-2 shadow-lg rounded-3">
                <div class="card-body p-4 p-md-5">
                    <form action="<?php echo e(route('component1.groups.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>

                        <h5 class="mb-3 text-primary border-bottom border-secondary pb-2"><i class="fas fa-users me-2"></i> Group Details</h5>
                        <div class="row g-4 mb-4">
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Group Name <span class="text-danger">*</span></label>
                                <input style="border: 1px solid #444;" type="text" name="name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('name')); ?>" required>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-bold">Nature <span class="text-danger">*</span></label>
                                <select style="border: 1px solid #444;" name="nature" class="form-select <?php $__errorArgs = ['nature'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                    <option value="">-- Select Group Nature --</option>
                                    <option value="new" <?php echo e(old('nature') == 'new' ? 'selected' : ''); ?>>New</option>
                                    <option value="progressing" <?php echo e(old('nature') == 'progressing' ? 'selected' : ''); ?>>Progressing</option>
                                    <option value="matured" <?php echo e(old('nature') == 'matured' ? 'selected' : ''); ?>>Matured</option>
                                </select>
                                <?php $__errorArgs = ['nature'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label fw-bold">State <span class="text-danger">*</span></label>
                                <input style="border: 1px solid #444;" type="text" name="state" class="form-control <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('state')); ?>" required>
                                <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label fw-bold">County <span class="text-danger">*</span></label>
                                <input style="border: 1px solid #444;" type="text" name="county" class="form-control <?php $__errorArgs = ['county'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('county')); ?>" required>
                                <?php $__errorArgs = ['county'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label fw-bold">Payam <span class="text-danger">*</span></label>
                                <input style="border: 1px solid #444;" type="text" name="payam" class="form-control <?php $__errorArgs = ['payam'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('payam')); ?>" required>
                                <?php $__errorArgs = ['payam'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <h5 class="mb-3 mt-4 text-primary border-bottom border-secondary pb-2"><i class="fas fa-handshake me-2"></i> Establishment & Dates</h5>
                        <div class="row g-4 mb-4">
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Establishing Org</label>
                                <input style="border: 1px solid #444;" type="text" name="establishing_org_name" class="form-control" value="<?php echo e(old('establishing_org_name')); ?>">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-bold">Establishment Type <span class="text-danger">*</span></label>
                                <select style="border: 1px solid #444;" name="establishment_type" class="form-select <?php $__errorArgs = ['establishment_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                    <option value="">-- Select Type --</option>
                                    <option value="self" <?php echo e(old('establishment_type') == 'self' ? 'selected' : ''); ?>>Self</option>
                                    <option value="cso" <?php echo e(old('establishment_type') == 'cso' ? 'selected' : ''); ?>>CSO</option>
                                    <option value="ngo" <?php echo e(old('establishment_type') == 'ngo' ? 'selected' : ''); ?>>NGO</option>
                                    <option value="government" <?php echo e(old('establishment_type') == 'government' ? 'selected' : ''); ?>>Government</option>
                                </select>
                                <?php $__errorArgs = ['establishment_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label fw-bold">Formation Date <span class="text-danger">*</span></label>
                                <input style="border: 1px solid #444;" type="date" name="date_formation" class="form-control <?php $__errorArgs = ['date_formation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('date_formation')); ?>" required>
                                <?php $__errorArgs = ['date_formation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label fw-bold">VSLA Registration Date</label>
                                <input style="border: 1px solid #444;" type="date" name="vsla_registration_date" class="form-control" value="<?php echo e(old('vsla_registration_date')); ?>">
                            </div>

                            <div class="col-md-4">
                                <label class="form-label fw-bold">Leadership <span class="text-danger">*</span></label>
                                <select style="border: 1px solid #444;" name="leadership" class="form-select <?php $__errorArgs = ['leadership'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                    <option value="">-- Select Leadership --</option>
                                    <option value="adolescent_girl" <?php echo e(old('leadership') == 'adolescent_girl' ? 'selected' : ''); ?>>Adolescent Girl</option>
                                    <option value="woman" <?php echo e(old('leadership') == 'woman' ? 'selected' : ''); ?>>Woman</option>
                                </select>
                                <?php $__errorArgs = ['leadership'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="average_participation">Average Training Participation (%) <span class="text-danger">*</span></label>
                                    <input type="number" name="average_participation" id="average_participation" 
                                        class="form-control <?php $__errorArgs = ['average_participation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        value="<?php echo e(old('average_participation', $group->average_participation ?? '')); ?>" 
                                        step="0.01" min="0" max="100" placeholder="e.g. 87.5">
                                    <?php $__errorArgs = ['average_participation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Received Certificate?</label><br>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="received_certificate" id="cert_yes" value="1" 
                                            <?php echo e(old('received_certificate', $group->received_certificate ?? false) ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="cert_yes">Yes</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="received_certificate" id="cert_no" value="0" 
                                            <?php echo e(old('received_certificate', $group->received_certificate ?? false) ? '' : 'checked'); ?>>
                                        <label class="form-check-label" for="cert_no">No</label>
                                    </div>
                                    <?php $__errorArgs = ['received_certificate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-bold">Snapshot Month <span class="text-danger">*</span></label>
                                <input style="border: 1px solid #444;" type="month" name="month" class="form-control <?php $__errorArgs = ['month'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('month')); ?>" required>
                                <?php $__errorArgs = ['month'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="mt-4 pt-3 border-top border-secondary text-end">
                            <a href="<?php echo e(route('component1.groups.index')); ?>" class="btn btn-outline-secondary me-2"><i class="fas fa-times me-1"></i> Cancel</a>
                            <button type="submit" class="btn btn-success"><i class="fas fa-save me-1"></i> Save Group</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\sswseepcomponents\resources\views/component1/groups/create.blade.php ENDPATH**/ ?>