<?php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component3.layout';
?>



<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-users text-success"></i> Record Prevention & Awareness Session</h2>
    <a href="<?php echo e(route('component3.prevention.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back
    </a>
</div>

<div class="card border-success">
    <div class="card-body">
        <form action="<?php echo e(route('component3.prevention.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <div class="row">
                <div class="col-md-4">
                    <label>Gender <span class="text-danger">*</span></label>
                    <select name="gender" class="form-select" required>
                        <option value="F" <?php echo e(old('gender') == 'F' ? 'selected' : ''); ?>>Female</option>
                        <option value="M" <?php echo e(old('gender') == 'M' ? 'selected' : ''); ?>>Male</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label>Age</label>
                    <input type="number" name="age" class="form-control" value="<?php echo e(old('age')); ?>" min="10" max="100">
                </div>
                <div class="col-md-4">
                    <label>Participant Category <span class="text-danger">*</span></label>
                    <select name="category_of_participants" class="form-select" required>
                        <option>Adult Female</option>
                        <option>Adult Male</option>
                        <option>Adolescent Girl</option>
                        <option>Adolescent Boy</option>
                        <option>Community Leader</option>
                        <option>Religious Leader</option>
                    </select>
                </div>
            </div>

            <div class="row mt-3">
                <div class="col-md-3">
                    <label>State <span class="text-danger">*</span></label>
                    <input type="text" name="state" class="form-control" value="<?php echo e(old('state')); ?>" required>
                </div>
                <div class="col-md-3">
                    <label>County <span class="text-danger">*</span></label>
                    <input type="text" name="county" class="form-control" value="<?php echo e(old('county')); ?>" required>
                </div>
                <div class="col-md-3">
                    <label>Payam <span class="text-danger">*</span></label>
                    <input type="text" name="payam" class="form-control" value="<?php echo e(old('payam')); ?>" required>
                </div>
                <div class="col-md-3">
                    <label>Boma</label>
                    <input type="text" name="boma" class="form-control" value="<?php echo e(old('boma')); ?>">
                </div>
            </div>

            <div class="row mt-4">
                <div class="col-12">
                    <h5 class="text-success">Sessions Delivered (Check all that apply)</h5>
                    <div class="row">
                        <?php $__currentLoopData = ['prevention_messages', 'referral_pathways', 'conflict_resolution', 'male_engagement_dialogue', 'positive_masculinity_activity']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="<?php echo e($session); ?>" value="1" id="<?php echo e($session); ?>">
                                <label class="form-check-label" for="<?php echo e($session); ?>">
                                    <?php echo e(ucwords(str_replace('_', ' ', $session))); ?>

                                </label>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>

            <div class="row mt-3">
                <div class="col-md-6">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="received_iec_materials" value="1">
                        <label>Received IEC Materials</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="received_radio_talkshows" value="1">
                        <label>Heard Radio Talkshows / Aired Messages</label>
                    </div>
                </div>
                <div class="col-md-6">
                    <label>Session Date</label>
                    <input type="date" name="session_date" class="form-control" value="<?php echo e(old('session_date', today()->format('Y-m-d'))); ?>">
                </div>
            </div>

            <div class="text-center mt-4">
                <button type="submit" class="btn btn-sswseep text-white btn-lg px-5">
                    <i class="fas fa-save"></i> Save Prevention Record
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\sswseepcomponents\resources\views/component3/prevention/create.blade.php ENDPATH**/ ?>