<?php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component3.layout';
?>



<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>GBV Hotline Register</h2>
    <a href="<?php echo e(route('component3.hotline.create')); ?>" class="btn btn-sswseep text-white">
        <i class="fas fa-plus"></i> Register New Incident
    </a>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-success">
                    <tr>
                        <th>Incident ID</th>
                        <th>Survivor Code</th>
                        <th>Date of Report</th>
                        <th>GBV Type</th>
                        <th>Consent</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $registers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><strong><?php echo e($r->incident_id); ?></strong></td>
                        <td><?php echo e($r->survivor_code); ?></td>
                        <td><?php echo e($r->date_of_report->format('d/m/Y')); ?></td>
                        <td><?php echo e($r->gbv_type); ?></td>
                        <td><?php echo e($r->consent_given_for_information_sharing ? 'Yes' : 'No'); ?></td>
                        <td>
                            <a href="<?php echo e(route('component3.hotline.show', $r)); ?>" class="btn btn-sm btn-outline-primary">View</a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <?php echo e($registers->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\sswseepcomponents\resources\views/component3/hotline/index.blade.php ENDPATH**/ ?>