<?php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'component4.layouts.app';
?>



<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4 py-3">
    <!-- Dashboard Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        Registered Training Participants - Component 4
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="breadcrumb-item active">Component 4</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-lg-6">
                    <div class="d-flex justify-content-lg-end gap-2 dashboard-actions">
                        <a href="<?php echo e(route('component4.create')); ?>" class="btn btn-success">
                            <i class="bi bi-person-plus"></i> Register New
                        </a>
                        <a href="<?php echo e(route('component4.export')); ?>" class="btn btn-info text-white">
                            <i class="bi bi-file-earmark-excel"></i> Export Excel
                        </a>
                        <button onclick="generatePDF()" class="btn btn-danger">
                            <i class="bi bi-file-earmark-pdf"></i> PDF Report
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <form method="GET" action="<?php echo e(route('component4.index')); ?>" class="row g-3 mb-4">
        <div class="col-md-3">
            <select name="state" class="form-select">
                <option value="">All States</option>
                <?php $__currentLoopData = \App\Models\Component4\C4Participant::distinct()->orderBy('state_province')->pluck('state_province'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($state); ?>" <?php echo e(request('state') == $state ? 'selected' : ''); ?>><?php echo e($state); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="col-md-2">
            <select name="gender" class="form-select">
                <option value="">All Gender</option>
                <option value="female" <?php echo e(request('gender')=='female' ? 'selected':''); ?>>Female</option>
                <option value="male" <?php echo e(request('gender')=='male' ? 'selected':''); ?>>Male</option>
                <option value="other" <?php echo e(request('gender')=='other' ? 'selected':''); ?>>Other</option>
            </select>
        </div>
        <div class="col-md-3">
            <select name="module" class="form-select">
                <option value="">All Training Modules</option>
                <option value="gbv" <?php echo e(request('module')=='gbv' ? 'selected':''); ?>>GBV Programming</option>
                <option value="gender_eq" <?php echo e(request('module')=='gender_eq' ? 'selected':''); ?>>Gender Equality</option>
                <option value="project_mgt" <?php echo e(request('module')=='project_mgt' ? 'selected':''); ?>>Project Management</option>
            </select>
        </div>
        <div class="col-md-2">
            <button type="submit" class="btn btn-primary w-100">Filter</button>
        </div>
        <div class="col-md-2">
            <a href="<?php echo e(route('component4.index')); ?>" class="btn btn-secondary w-100">Clear</a>
        </div>
    </form>

    <!-- Quick Stats Cards -->
    <div class="row mb-4 g-3">
        <div class="col-md-3">
            <div class="stat-card p-3 rounded shadow-sm">
                <h5>Total Participants</h5>
                <h3 class="text-success"><?php echo e($stats['total_participants']); ?></h3>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card p-3 rounded shadow-sm">
                <h5>Female Participants</h5>
                <h3 class="text-danger"><?php echo e($stats['total_female']); ?></h3>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card p-3 rounded shadow-sm">
                <h5>Trained in GBV Programming</h5>
                <h3 class="text-success"><?php echo e($stats['trained_gbv']); ?></h3>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card p-3 rounded shadow-sm">
                <h5>Completed All Modules</h5>
                <h3 class="text-primary"><?php echo e($stats['completed_all']); ?></h3>
            </div>
        </div>
    </div>

    <!-- Visualizations -->
    <div class="row mb-5">
        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">Training Module Completion</h5>
                </div>
                <div class="card-body">
                    <canvas id="moduleChart" height="300"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">Participants by State</h5>
                </div>
                <div class="card-body">
                    <canvas id="stateChart" height="300"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">Gender Distribution</h5>
                </div>
                <div class="card-body">
                    <canvas id="genderChart" height="300"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">GBV & Gender Equality Training</h5>
                </div>
                <div class="card-body">
                    <canvas id="gbvChart" height="300"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Participants Table -->
    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-success">
                        <tr>
                            <th>S/N</th>
                            <th>Name</th>
                            <th>Organization</th>
                            <th>Gender</th>
                            <th>State</th>
                            <th>GBV</th>
                            <th>Gender Eq.</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $participants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($p->serial_no ?? $loop->iteration); ?></td>
                            <td><?php echo e($p->name); ?></td>
                            <td><?php echo e($p->organization ?? '-'); ?></td>
                            <td>
                                <span class="badge bg-<?php echo e($p->gender == 'female' ? 'danger' : 'primary'); ?>">
                                    <?php echo e(ucfirst($p->gender)); ?>

                                </span>
                            </td>
                            <td><?php echo e($p->state_province); ?></td>
                            <td><?php echo $p->trained_gbv_programming ? '<i class="bi bi-check-circle-fill text-success"></i>' : '<i class="bi bi-x-circle text-muted"></i>'; ?></td>
                            <td><?php echo $p->trained_gender_equality ? '<i class="bi bi-check-circle-fill text-success"></i>' : '<i class="bi bi-x-circle text-muted"></i>'; ?></td>
                            <td>
                                <a href="<?php echo e(route('c4.edit', $p)); ?>" class="btn btn-sm btn-warning"><i class="bi bi-pencil"></i></a>
                                <form action="<?php echo e(route('c4.destroy', $p)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                    <button class="btn btn-sm btn-danger" onclick="return confirm('Delete?')"><i class="bi bi-trash"></i></button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="8" class="text-center text-muted py-4">No participants registered yet.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e($participants->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jspdf@2.5.1/dist/jspdf.umd.min.js"></script>
<script>
// Data from Laravel (passed via controller)
const chartData = <?php echo json_encode($stats, 15, 512) ?>;
const stateData = <?php echo json_encode(\App\Models\Component4\C4Participant::selectRaw('state_province, count(*) as total')
    ->groupBy('state_province')->pluck('total', 'state_province')) ?>;

new Chart(document.getElementById('moduleChart'), {
    type: 'bar',
    data: {
        labels: ['Project Mgt', 'GRM', 'M&E', 'GBV Prog', 'Gender Eq', 'Resource Mob', 'Leadership'],
        datasets: [{
            label: 'Trained',
            data: [
                <?php echo e(\App\Models\Component4\C4Participant::where('trained_project_management', true)->count()); ?>,
                <?php echo e(\App\Models\Component4\C4Participant::where('trained_grm', true)->count()); ?>,
                <?php echo e(\App\Models\Component4\C4Participant::where('trained_monitoring_evaluation', true)->count()); ?>,
                <?php echo e($stats['trained_gbv']); ?>,
                <?php echo e($stats['trained_gender_eq']); ?>,
                <?php echo e(\App\Models\Component4\C4Participant::where('trained_resource_mobilization', true)->count()); ?>,
                <?php echo e(\App\Models\Component4\C4Participant::where('trained_leadership_management', true)->count()); ?>

            ],
            backgroundColor: '#006400'
        }]
    },
    options: { responsive: true, plugins: { legend: { display: false } } }
});

new Chart(document.getElementById('stateChart'), {
    type: 'doughnut',
    data: {
        labels: Object.keys(stateData),
        datasets: [{ data: Object.values(stateData), backgroundColor: ['#006400','#087f23','#4caf50','#66bb6a','#81c784','#a5d6a7'] }]
    },
    options: { responsive: true }
});

new Chart(document.getElementById('genderChart'), {
    type: 'pie',
    data: {
        labels: ['Female', 'Male', 'Other'],
        datasets: [{
            data: [<?php echo e($stats['total_female']); ?>, <?php echo e($stats['total_male']); ?>, <?php echo e(\App\Models\Component4\C4Participant::where('gender', 'other')->count()); ?>],
            backgroundColor: ['#d81b60', '#1976d2', '#9c27b0']
        }]
    }
});

new Chart(document.getElementById('gbvChart'), {
    type: 'bar',
    data: {
        labels: ['GBV Programming', 'Gender Equality'],
        datasets: [{
            label: 'Trained',
            data: [<?php echo e($stats['trained_gbv']); ?>, <?php echo e($stats['trained_gender_eq']); ?>],
            backgroundColor: ['#d32f2f', '#7b1fa2']
        }]
    },
    options: { indexAxis: 'y', responsive: true }
});

// PDF Export
function generatePDF() {
    const { jsPDF } = window.jspdf;
    const doc = new jsPDF('l', 'mm', 'a4');
    
    doc.setFontSize(18);
    doc.text('Component 4: Training Tracker Report', 15, 20);
    doc.setFontSize(12);
    doc.text(`Generated on: <?php echo e(now()->format('d M Y')); ?>`, 15, 30);
    
    doc.setFontSize(14);
    doc.text('Key Statistics', 15, 45);
    doc.setFontSize(11);
    doc.text(`• Total Participants: <?php echo e($stats['total_participants']); ?>`, 20, 55);
    doc.text(`• Female: <?php echo e($stats['total_female']); ?> | Male: <?php echo e($stats['total_male']); ?>`, 20, 62);
    doc.text(`• Trained in GBV Programming: <?php echo e($stats['trained_gbv']); ?>`, 20, 69);
    doc.text(`• Completed All Modules: <?php echo e($stats['completed_all']); ?>`, 20, 76);

    // Add table or charts as images (advanced) or keep simple
    doc.save('Component4_Training_Report_<?php echo e(now()->format('Y-m-d')); ?>.pdf');
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\sswseepcomponents\resources\views/component4/index.blade.php ENDPATH**/ ?>