<?php
    $layout = auth()->user()->role === 'super_admin' ? 'layouts.admin' : 'layouts.app';
?>



<?php $__env->startSection('title', 'Individual Members'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Dashboard Header -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center dashboard-header-content">
                <div class="col-lg-6">
                    <h1 class="dashboard-title">
                        <i class="fas fa-tachometer-alt" style="color: var(--dhis2-blue-primary);"></i>
                        Component 1 Dashboard
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="breadcrumb-item active">Individual Members</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-lg-6">
                    <div class="d-flex justify-content-lg-end gap-2 dashboard-actions">
                        <a href="<?php echo e(route('component1.members.create')); ?>" class="btn btn-success">
                            Add New Member
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <form method="GET" class="mb-4">
        <div class="row g-3">
            <div class="col-md-4">
                <select name="group_id" class="form-select">
                    <option value="">All Groups</option>
                    <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($id); ?>" <?php echo e(request('group_id') == $id ? 'selected' : ''); ?>>
                            <?php echo e($name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-4">
                <input type="text" name="search" class="form-control" placeholder="Search name..." value="<?php echo e(request('search')); ?>">
            </div>
            <div class="col-md-4">
                <button type="submit" class="btn btn-outline-success">Filter</button>
                <a href="<?php echo e(route('component1.members.index')); ?>" class="btn btn-outline-secondary">Clear</a>
            </div>
        </div>
    </form>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="card border-0 shadow-sm">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>Serial</th>
                            <th>Name</th>
                            <th>Group</th>
                            <th>Gender</th>
                            <th>Age</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($member->serial_no); ?></td>
                                <td><?php echo e($member->name); ?></td>
                                <td><?php echo e($member->group->name); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($member->gender == 'female' ? 'pink' : 'info'); ?>">
                                        <?php echo e(ucfirst($member->gender)); ?>

                                    </span>
                                </td>
                                <td><?php echo e($member->age); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($member->active ? 'success' : 'secondary'); ?>">
                                        <?php echo e($member->active ? 'Active' : 'Inactive'); ?>

                                    </span>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('component1.members.show', $member)); ?>" class="btn btn-sm btn-outline-primary">View</a>
                                    <a href="<?php echo e(route('component1.members.edit', $member)); ?>" class="btn btn-sm btn-outline-secondary">Edit</a>
                                    <form action="<?php echo e(route('component1.members.destroy', $member)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete?')">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-4 text-muted">No members found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="mt-4">
        <?php echo e($members->appends(request()->query())->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\sswseepcomponents\resources\views/component1/members/index.blade.php ENDPATH**/ ?>